# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class PinnacleFileUploadMetadata(UniversalBaseModel):
    file_name: typing_extensions.Annotated[str, FieldMetadata(alias="fileName")] = pydantic.Field()
    """
    Name of the uploaded file.
    """

    content_type: typing_extensions.Annotated[str, FieldMetadata(alias="contentType")] = pydantic.Field()
    """
    MIME type of the file.
    """

    expires_at: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="expiresAt")] = pydantic.Field(
        default=None
    )
    """
    Expiration date in ISO 8601 format for file download access.<br>
    
    Null indicates that `download.expiresAt` was not provided and the expiration time is defaulted to one hour after uploading.
    """

    delete_at: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="deleteAt")] = pydantic.Field(
        default=None
    )
    """
    Deletion date for the file in ISO 8601 format. After this date, the file will be automatically deleted from our storage.<br>
    
    If this field is not provided, the file will not be deleted. You can still schedule deletion or delete the file manually in the Storage page in the dashboard.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
