# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .buy_response_capabilities import BuyResponseCapabilities


class PurchasedNumber(UniversalBaseModel):
    """
    Details of a phone number that has been successfully purchased and provisioned.
    Includes all communication capabilities currently enabled for immediate use.
    """

    number: str = pydantic.Field()
    """
    Purchased phone number in E.164 format.
    """

    capabilities: BuyResponseCapabilities = pydantic.Field()
    """
    Enabled communication features for the phone number.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
