# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .rcs_base_options import RcsBaseOptions


class RcsBase(UniversalBaseModel):
    from_: typing_extensions.Annotated[str, FieldMetadata(alias="from")] = pydantic.Field()
    """
    Your RCS agent ID which must be prefixed with 'agent_'.
    """

    options: typing.Optional[RcsBaseOptions] = pydantic.Field(default=None)
    """
    Configure how your RCS message is sent and tracked.
    """

    to: str = pydantic.Field()
    """
    Recipient's phone number in E.164 format.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
