# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .message_schedule import MessageSchedule
from .tracking import Tracking


class RcsBaseOptions(UniversalBaseModel):
    """
    Configure how your RCS message is sent and tracked.
    """

    schedule: typing.Optional[MessageSchedule] = None
    test_mode: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Send via the test agent to whitelisted test devices. Useful for development and debugging.
    """

    tracking: typing.Optional[Tracking] = None
    transcode: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Media files and card media will be transcoded to a supported RCS format. This adds a small delay to sending the message. Ignored for rich text messages.
    """

    validate_: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="validate")] = pydantic.Field(
        default=None
    )
    """
    Validate your message for any unsupported files. <br>
    
    If failed, errors will be thrown and the message will not send.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
