# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class RcsButtonScheduleEvent(UniversalBaseModel):
    """
    Button that prompts the recipient to add an event to their calendar.
    """

    event_description: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="eventDescription")] = (
        pydantic.Field(default=None)
    )
    """
    Detailed description for the calendar event.
    """

    event_end_time: typing_extensions.Annotated[str, FieldMetadata(alias="eventEndTime")] = pydantic.Field()
    """
    End time in ISO 8601 format.
    """

    event_start_time: typing_extensions.Annotated[str, FieldMetadata(alias="eventStartTime")] = pydantic.Field()
    """
    Starting time in ISO 8601 format.
    """

    event_title: typing_extensions.Annotated[str, FieldMetadata(alias="eventTitle")] = pydantic.Field()
    """
    Title of the event.
    """

    metadata: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional additional data to attach to this button.
    """

    title: str = pydantic.Field()
    """
    Display text for the button.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
