# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .rcs_button_send_location_lat_long import RcsButtonSendLocationLatLong


class RcsButtonSendLocation(UniversalBaseModel):
    """
    Button that shares a specific location with the recipient when tapped.
    """

    lat_long: typing_extensions.Annotated[RcsButtonSendLocationLatLong, FieldMetadata(alias="latLong")] = (
        pydantic.Field()
    )
    """
    Geographic coordinates of the location to share.
    """

    metadata: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional additional data to attach to this button.
    """

    title: str = pydantic.Field()
    """
    Display text for the button.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
