# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class RcsButtonTrigger(UniversalBaseModel):
    """
    Button that sends custom data back to your application when tapped by the recipient.
    """

    metadata: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional additional data to attach to this button.
    """

    payload: str = pydantic.Field()
    """
    Custom data sent to your webhook when the button is tapped. Use this to identify the user's choice.
    """

    title: str = pydantic.Field()
    """
    Display text for the button.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
