# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .rcs_campaign_schema_agent import RcsCampaignSchemaAgent
from .rcs_campaign_schema_links import RcsCampaignSchemaLinks
from .rcs_campaign_schema_opt_in import RcsCampaignSchemaOptIn
from .rcs_campaign_schema_opt_out import RcsCampaignSchemaOptOut
from .rcs_campaign_schema_use_case import RcsCampaignSchemaUseCase


class RcsCampaign(UniversalBaseModel):
    agent: typing.Optional[RcsCampaignSchemaAgent] = pydantic.Field(default=None)
    """
    Agent configured to the campaign.
    """

    campaign_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="campaignId")] = pydantic.Field(
        default=None
    )
    """
    Unique identifier for the campaign.
    """

    brand_verification_url: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="brandVerificationUrl")
    ] = pydantic.Field(default=None)
    """
    Link to document verifying the brand's name. This may be the certificate of incorporation, business license, or other relevant document. You can typically find this on the Secretary of State website.
    """

    expected_agent_responses: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="expectedAgentResponses")
    ] = pydantic.Field(default=None)
    """
    List of what the agent might say to users.
    """

    links: typing.Optional[RcsCampaignSchemaLinks] = pydantic.Field(default=None)
    """
    Legal documentation links.
    """

    opt_in: typing_extensions.Annotated[typing.Optional[RcsCampaignSchemaOptIn], FieldMetadata(alias="optIn")] = (
        pydantic.Field(default=None)
    )
    """
    Opt-in configuration.
    """

    opt_out: typing_extensions.Annotated[typing.Optional[RcsCampaignSchemaOptOut], FieldMetadata(alias="optOut")] = (
        pydantic.Field(default=None)
    )
    """
    Opt-out configuration.
    """

    use_case: typing_extensions.Annotated[typing.Optional[RcsCampaignSchemaUseCase], FieldMetadata(alias="useCase")] = (
        pydantic.Field(default=None)
    )
    """
    Use case classification for the campaign.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
