# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .rcs_campaign_schema_extra_agent_emails_item import RcsCampaignSchemaExtraAgentEmailsItem
from .rcs_campaign_schema_extra_agent_phones_item import RcsCampaignSchemaExtraAgentPhonesItem
from .rcs_campaign_schema_extra_agent_websites_item import RcsCampaignSchemaExtraAgentWebsitesItem


class RcsCampaignSchemaExtraAgent(UniversalBaseModel):
    """
    Agent configured to the campaign.
    """

    color: typing.Optional[str] = pydantic.Field(default=None)
    """
    Color of the agent's buttons.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the agent.
    """

    emails: typing.List[RcsCampaignSchemaExtraAgentEmailsItem] = pydantic.Field()
    """
    List of emails.
    """

    hero_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="heroUrl")] = pydantic.Field(
        default=None
    )
    """
    Link to the agent's hero. Hero must be an image file with dimensions 1440x448px.
    """

    icon_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="iconUrl")] = pydantic.Field(
        default=None
    )
    """
    Link to the agent's icon. Icon must be an image file with dimensions 224x224px.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the agent.
    """

    phones: typing.List[RcsCampaignSchemaExtraAgentPhonesItem] = pydantic.Field()
    """
    List of phone numbers.
    """

    websites: typing.List[RcsCampaignSchemaExtraAgentWebsitesItem] = pydantic.Field()
    """
    List of urls.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
