# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .profile_status_enum import ProfileStatusEnum


class RcsCampaignStatus(UniversalBaseModel):
    """
    Response for get RCS campaign status.
    """

    errors: typing.List[str] = pydantic.Field()
    """
    List of errors that occured.
    """

    id: str = pydantic.Field()
    """
    The unique identifier of the RCS campaign. This identifier is a string that always begins with the prefix `rcs_`, for example: `rcs_1234567890`.
    """

    status: ProfileStatusEnum = pydantic.Field()
    """
    Current review status of the RCS campaign. <br>
    
    `INCOMPLETE`: Not submitted.<br>
    `IN REVIEW`: Being reviewed by carriers.<br>
    `VERIFIED`: Approved and ready to send messages.<br>
    `FAILED`: Issues and errors related to the campaign's details. See [errors](rcs-campaign#response.body.errors) for these potential issues.<br>
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
