# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class RcsCapabilityActions(UniversalBaseModel):
    """
    Supported button action types inside the rich cards or quick replies. Each key is a button action type that defines a specific button type in the Pinnacle API.
    """

    open_url: typing_extensions.Annotated[bool, FieldMetadata(alias="openUrl")] = pydantic.Field()
    """
    Buttons that open URLs are supported
    """

    call: bool = pydantic.Field()
    """
    Buttons that make phone calls are supported
    """

    trigger: bool = pydantic.Field()
    """
    Buttons that trigger actions are supported
    """

    request_user_location: typing_extensions.Annotated[bool, FieldMetadata(alias="requestUserLocation")] = (
        pydantic.Field()
    )
    """
    Buttons that request user location are supported
    """

    schedule_event: typing_extensions.Annotated[bool, FieldMetadata(alias="scheduleEvent")] = pydantic.Field()
    """
    Buttons are supported
    """

    send_location: typing_extensions.Annotated[bool, FieldMetadata(alias="sendLocation")] = pydantic.Field()
    """
    Buttons that send location are supported
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
