# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .rcs_cards_cards_item import RcsCardsCardsItem
from .rich_button import RichButton


class RcsCards(UniversalBaseModel):
    """
    Message containing cards, each with its own title, subtitle, and/or buttons. Quick replies can also be added. <br>

    See (supported file types)[https://app.pinnacle.sh/supported-file-types?type=RCS-CARD].
    """

    cards: typing.List[RcsCardsCardsItem] = pydantic.Field()
    """
    Collection of cards attached to the message.
    """

    quick_replies: typing_extensions.Annotated[typing.List[RichButton], FieldMetadata(alias="quickReplies")] = (
        pydantic.Field()
    )
    """
    List of interactive quick reply buttons in the message.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
