# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class RcsLinkResult(UniversalBaseModel):
    """
    Response containing the generated RCS service id and/or url. You can always create a link with the service id that is returned.
    To create a link follow the format: sms://{PHONE_NUMBER}?service_id={SERVICE_ID}&body={URL_ENCODED_BODY}
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The generated RCS link URL. If no phone number is provided, no url will be generated.
    """

    service_id: typing_extensions.Annotated[str, FieldMetadata(alias="serviceId")] = pydantic.Field()
    """
    The service ID used for the link
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
