# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .rcs_media_details_content import RcsMediaDetailsContent
from .rich_button import RichButton


class RcsMediaContent(UniversalBaseModel):
    """
    Message containing a media file and/or text with optional quick reply buttons. <br>

    See (supported file types)[https://app.pinnacle.sh/supported-file-types?type=RCS-MEDIA].
    """

    media: RcsMediaDetailsContent
    quick_replies: typing_extensions.Annotated[typing.List[RichButton], FieldMetadata(alias="quickReplies")] = (
        pydantic.Field()
    )
    """
    List of interactive quick reply buttons in the message.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
