# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class RcsMediaDetailsContent(UniversalBaseModel):
    """
    Metadata about the media file in the message.
    """

    full_path: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="fullPath")] = pydantic.Field(
        default=None
    )
    """
    Path to the file in Pinnacle's storage.
    """

    mime_type: typing_extensions.Annotated[str, FieldMetadata(alias="mimeType")] = pydantic.Field()
    """
    Detected MIME type of the media file.
    """

    url: str = pydantic.Field()
    """
    Direct URL to the media file.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
