# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .rich_button import RichButton


class RcsValidateContentMedia(UniversalBaseModel):
    """
    Message containing a media file and/or text with optional quick reply buttons.<br>

    See [supported media types](https://app.pinnacle.sh/supported-file-types?type=RCS-MEDIA).
    """

    media: str = pydantic.Field()
    """
    Media file URLs to send.
    """

    quick_replies: typing_extensions.Annotated[typing.List[RichButton], FieldMetadata(alias="quickReplies")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
