# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from .rcs_base import RcsBase
from .rich_button import RichButton


class RichMediaMessage(RcsBase):
    media: str = pydantic.Field()
    """
    Media file URLs to send. <br>
    
    See [supported media types](https://app.pinnacle.sh/supported-file-types?type=RCS-MEDIA).
    """

    quick_replies: typing_extensions.Annotated[typing.List[RichButton], FieldMetadata(alias="quickReplies")] = (
        pydantic.Field()
    )
    """
    List of interactive quick reply buttons in the message.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
