# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class ScheduledSendResponseConfig(UniversalBaseModel):
    """
    Configuration for the scheduled message.
    """

    send_at: typing_extensions.Annotated[str, FieldMetadata(alias="sendAt")] = pydantic.Field()
    """
    When the message will be sent in ISO 8601 format.
    """

    recurrence: typing.Optional[str] = pydantic.Field(default=None)
    """
    AWS cron expression used for recurring messages.
    """

    timezone: str = pydantic.Field()
    """
    IANA timezone identifier.
    """

    end_date: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="endDate")] = pydantic.Field(
        default=None
    )
    """
    When the recurring messages stops in ISO 8601 format.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
