# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class SentRcsDetails(UniversalBaseModel):
    message_id: typing_extensions.Annotated[str, FieldMetadata(alias="messageId")] = pydantic.Field()
    """
    Unique identifier for the sent RCS message. This identifier is a string that always begins with the prefix `msg_`, for example: `msg_1234567890`.
    """

    segments: int = pydantic.Field()
    """
    Total number of segments used across the message.
    """

    total_cost: typing_extensions.Annotated[float, FieldMetadata(alias="totalCost")] = pydantic.Field()
    """
    Total cost of sending the message.
    """

    sender: str = pydantic.Field()
    """
    Sender's phone number in E.164 format.
    """

    recipient: str = pydantic.Field()
    """
    Recipient's phone number in E.164 format.
    """

    status: typing.Literal["queued"] = pydantic.Field(default="queued")
    """
    Current status of the message.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
