# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .send_sms_response_segments import SendSmsResponseSegments


class SentSmsDetails(UniversalBaseModel):
    message_id: typing_extensions.Annotated[str, FieldMetadata(alias="messageId")] = pydantic.Field()
    """
    Unique identifier for the sent message. This identifier is a string that always begins with the prefix `msg_`, for example: `msg_1234567890`.
    """

    segments: SendSmsResponseSegments = pydantic.Field()
    """
    Details about how the message was segmented for sending.
    """

    total_cost: typing_extensions.Annotated[float, FieldMetadata(alias="totalCost")] = pydantic.Field()
    """
    Total cost of sending the message.
    """

    sender: str = pydantic.Field()
    """
    Sender's phone number in E.164 format.
    """

    recipient: str = pydantic.Field()
    """
    Recipient's phone number in E.164 format.
    """

    status: typing.Literal["queued"] = pydantic.Field(default="queued")
    """
    Message is queued for delivery.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
