# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .sms_validation_response_segments_gsm_7 import SmsValidationResponseSegmentsGsm7
from .sms_validation_response_segments_utf_16 import SmsValidationResponseSegmentsUtf16


class SmsValidationResponseSegments(UniversalBaseModel):
    """
    Details about how the SMS content would be segmented for delivery.
    """

    gsm_7: typing_extensions.Annotated[SmsValidationResponseSegmentsGsm7, FieldMetadata(alias="gsm7")] = (
        pydantic.Field()
    )
    """
    Segmentation details when your message is encoded with GSM-7.
    """

    utf_16: typing_extensions.Annotated[SmsValidationResponseSegmentsUtf16, FieldMetadata(alias="utf16")] = (
        pydantic.Field()
    )
    """
    Segmentation details when your message is encoded with UTF-16.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
