# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class SmsValidationResponseSegmentsGsm7(UniversalBaseModel):
    """
    Segmentation details when your message is encoded with GSM-7.
    """

    total_bytes: typing_extensions.Annotated[int, FieldMetadata(alias="totalBytes")] = pydantic.Field()
    """
    Total number of bytes used by the GSM-7 segments.
    """

    unsupported: typing.List[str] = pydantic.Field()
    """
    Characters not supported by GSM-7 encoding.
    """

    value: typing.List[str] = pydantic.Field()
    """
    Message broken down into segments using GSM-7 encoding.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
