# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .sms_validation_response_segments import SmsValidationResponseSegments
from .sms_validation_response_total import SmsValidationResponseTotal


class SmsValidationResult(UniversalBaseModel):
    is_over_segment_limit: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="isOverSegmentLimit")
    ] = pydantic.Field(default=None)
    """
    Indicates if the message exceeds the allowed segment limit. <br>
    
    For SMS, this is limit is 10.
    """

    segments: SmsValidationResponseSegments = pydantic.Field()
    """
    Details about how the SMS content would be segmented for delivery.
    """

    total: SmsValidationResponseTotal
    unit: float = pydantic.Field()
    """
    Cost per message segment.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
