# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .message_volume_enum import MessageVolumeEnum
from .upsert_toll_free_campaign_opt_in import UpsertTollFreeCampaignOptIn
from .upsert_toll_free_campaign_use_case import UpsertTollFreeCampaignUseCase


class TollFreeCampaign(UniversalBaseModel):
    campaign_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="campaignId")] = pydantic.Field(
        default=None
    )
    """
    Unique identifier for the campaign. Must begin with the prefix `tf_`.
    """

    monthly_volume: typing_extensions.Annotated[
        typing.Optional[MessageVolumeEnum], FieldMetadata(alias="monthlyVolume")
    ] = None
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Display name of the campaign.
    """

    opt_in: typing_extensions.Annotated[typing.Optional[UpsertTollFreeCampaignOptIn], FieldMetadata(alias="optIn")] = (
        pydantic.Field(default=None)
    )
    """
    Opt-in keyword settings.
    """

    production_message_content: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="productionMessageContent")
    ] = pydantic.Field(default=None)
    """
    Explain message that would be sent.
    """

    use_case: typing_extensions.Annotated[
        typing.Optional[UpsertTollFreeCampaignUseCase], FieldMetadata(alias="useCase")
    ] = pydantic.Field(default=None)
    """
    Use case classification for the campaign.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
