# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from .extended_brand import ExtendedBrand
from .profile_status_enum import ProfileStatusEnum
from .toll_free_campaign import TollFreeCampaign


class TollFreeCampaignWithExtendedBrandAndStatus(TollFreeCampaign):
    brand: ExtendedBrand = pydantic.Field()
    """
    Brand associated with this campaign.
    """

    status: ProfileStatusEnum = pydantic.Field()
    """
    Current review status of the brand.<br>
    
    `INCOMPLETE`: Has not been submitted.<br>
    `PENDING`: Currently being reviewed.<br>
    `VERIFIED`: Verified and good to go.<br>
    `VETTED`: Brand has been vetted by an external provider and has received vetting scores.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
