# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .user_event_conversation import UserEventConversation


class UserEvent(UniversalBaseModel):
    """
    Represents an event triggered by a user such as when they start typing.
    """

    type: typing.Literal["USER.TYPING"] = pydantic.Field(default="USER.TYPING")
    """
    Type of user event.
    """

    started_at: typing_extensions.Annotated[str, FieldMetadata(alias="startedAt")] = pydantic.Field()
    """
    Timestamp when the user event started in ISO 8601 format.
    """

    conversation: UserEventConversation = pydantic.Field()
    """
    Conversation metadata containing the conversation ID, sender, and recipient information.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
