# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class UserEventConversation(UniversalBaseModel):
    """
    Conversation metadata containing the conversation ID, sender, and recipient information.
    """

    id: int = pydantic.Field()
    """
    Unique identifier for the conversation. To get more conversation details, use the [POST /conversations/get](/api-reference/conversations/get) endpoint.
    """

    from_: typing_extensions.Annotated[str, FieldMetadata(alias="from")] = pydantic.Field()
    """
    Phone number of the user who triggered the event.
    """

    to: str = pydantic.Field()
    """
    Agent ID that the user is interacting with.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
