# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class VCardName(UniversalBaseModel):
    """
    Structured name components.
    """

    family_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="familyName")] = pydantic.Field(
        default=None
    )
    """
    Last name or surname.
    """

    given_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="givenName")] = pydantic.Field(
        default=None
    )
    """
    First name or given name.
    """

    additional_names: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="additionalNames")
    ] = pydantic.Field(default=None)
    """
    Middle names or additional names.
    """

    honorific_prefixes: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="honorificPrefixes")
    ] = pydantic.Field(default=None)
    """
    Title prefixes like "Dr.", "Mr.", "Ms.".
    """

    honorific_suffixes: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="honorificSuffixes")
    ] = pydantic.Field(default=None)
    """
    Title suffixes like "Jr.", "Sr.", "PhD".
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
