# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .v_card_geo import VCardGeo
from .v_card_name import VCardName
from .v_card_organization import VCardOrganization
from .vcard_address import VcardAddress
from .vcard_email import VcardEmail
from .vcard_phone import VcardPhone


class Vcard(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the contact. This identifier is a string that always begins with the prefix `cc_`, for example: `cc_1234567890`.
    """

    formatted_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="formattedName")] = (
        pydantic.Field(default=None)
    )
    """
    Full display name for the vCard.
    """

    name: typing.Optional[VCardName] = pydantic.Field(default=None)
    """
    Structured name components.
    """

    nickname: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Nicknames or aliases.
    """

    birthday: typing.Optional[str] = pydantic.Field(default=None)
    """
    Birthday in ISO 8601 date format (YYYY-MM-DD).
    """

    addresses: typing.Optional[typing.List[VcardAddress]] = pydantic.Field(default=None)
    """
    Physical addresses.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Website URL.
    """

    phones: typing.Optional[typing.List[VcardPhone]] = pydantic.Field(default=None)
    """
    Phone numbers.
    """

    emails: typing.Optional[typing.List[VcardEmail]] = pydantic.Field(default=None)
    """
    Email addresses.
    """

    timezone: typing.Optional[str] = pydantic.Field(default=None)
    """
    Timezone (e.g., "America/New_York").
    """

    geo: typing.Optional[VCardGeo] = pydantic.Field(default=None)
    """
    Geographic coordinates.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    Job title or position.
    """

    role: typing.Optional[str] = pydantic.Field(default=None)
    """
    Role or function within the organization.
    """

    organization: typing.Optional[VCardOrganization] = pydantic.Field(default=None)
    """
    Organization or company information.
    """

    categories: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Categories or tags for organizing contacts.
    """

    note: typing.Optional[str] = pydantic.Field(default=None)
    """
    Additional notes or comments.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
