# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .v_card_address_schema_type_item import VCardAddressSchemaTypeItem


class VcardAddress(UniversalBaseModel):
    country_name: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="countryName")] = (
        pydantic.Field(default=None)
    )
    """
    Country name.
    """

    extended_address: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="extendedAddress")] = (
        pydantic.Field(default=None)
    )
    """
    Extended address information (apartment, suite, etc.).
    """

    fulladdress: typing.Optional[str] = pydantic.Field(default=None)
    """
    Complete formatted address as a single string.
    """

    locality: typing.Optional[str] = pydantic.Field(default=None)
    """
    City or locality.
    """

    postal_code: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="postalCode")] = pydantic.Field(
        default=None
    )
    """
    ZIP code or postal code.
    """

    post_office_box: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="postOfficeBox")] = (
        pydantic.Field(default=None)
    )
    """
    P.O. Box number.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    State, province, or region.
    """

    street_address: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="streetAddress")] = (
        pydantic.Field(default=None)
    )
    """
    Street address or street name and number.
    """

    type: typing.Optional[typing.List[VCardAddressSchemaTypeItem]] = pydantic.Field(default=None)
    """
    Address type classifications.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
