# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class VettingFeedback(UniversalBaseModel):
    description: str = pydantic.Field()
    """
    Detailed description of the feedback.
    """

    display_name: typing_extensions.Annotated[str, FieldMetadata(alias="displayName")] = pydantic.Field()
    """
    Human-readable name of the feedback item.
    """

    fields: typing.List[str] = pydantic.Field()
    """
    Fields affected by this feedback item.
    """

    id: str = pydantic.Field()
    """
    Feedback item identifier.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
