# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .vetting_history_vetting_status import VettingHistoryVettingStatus


class VettingHistory(UniversalBaseModel):
    provider: typing.Literal["AEGIS"] = pydantic.Field(default="AEGIS")
    """
    The vetting provider used.
    """

    vetting_class: typing_extensions.Annotated[typing.Literal["STANDARD"], FieldMetadata(alias="vettingClass")] = (
        pydantic.Field(default="STANDARD")
    )
    """
    The vetting class level.
    """

    vetting_date: typing_extensions.Annotated[str, FieldMetadata(alias="vettingDate")] = pydantic.Field()
    """
    ISO 8601 formatted timestamp of when the vetting was initiated.
    """

    vetting_score: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="vettingScore")] = (
        pydantic.Field(default=None)
    )
    """
    Vetting score if available.
    """

    vetting_status: typing_extensions.Annotated[VettingHistoryVettingStatus, FieldMetadata(alias="vettingStatus")] = (
        pydantic.Field()
    )
    """
    Current status of the vetting process.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
