# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class Webhooks(UniversalBaseModel):
    """
    Webhook configuration that defines where event notifications are sent.
    """

    endpoint: str = pydantic.Field()
    """
    URL where webhook events are delivered.
    """

    id: str = pydantic.Field()
    """
    The unique identifier of the webhook. This identifier is a string that always begins with the prefix `wh_`, for example: `wh_1234567890`.
    """

    name: str = pydantic.Field()
    """
    Name of the webhook.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
