# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ZodError(UniversalBaseModel):
    description: str = pydantic.Field()
    """
    Human-readable summary of validation failures.
    """

    errors: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    Structured dictionary of issues containing two main sections:
    - `errors`: Array of global validation errors not tied to specific fields
    - `properties`: Object mapping field names to their specific validation errors, where each field contains an `errors` array
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
