# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.webhook_result import WebhookResult
from .raw_client import AsyncRawWebhooksClient, RawWebhooksClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WebhooksClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWebhooksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWebhooksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWebhooksClient
        """
        return self._raw_client

    def get(
        self, *, identifiers: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> WebhookResult:
        """
        Retrieve all webhook that are set up to receive events for specific URLs or phone numbers.

        Parameters
        ----------
        identifiers : typing.Sequence[str]
            List of URLs or phone numbers in E.164 format that the webhook is attached to.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookResult
            Returns all webhooks matching the search criteria. <br>

            Results are sorted by ID and duplicates are removed. This identifier is a string that always begins with the prefix `wh_`, for example: `wh_1234567890`.

        Examples
        --------
        from rcs import Pinnacle

        client = Pinnacle(
            api_key="YOUR_API_KEY",
        )
        client.webhooks.get(
            identifiers=[
                "https://www.pinnacle.sh/payment",
                "+14155678901",
                "https://www.pinnacle.sh/sms-callback",
                "+14153456659",
            ],
        )
        """
        _response = self._raw_client.get(identifiers=identifiers, request_options=request_options)
        return _response.data


class AsyncWebhooksClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWebhooksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWebhooksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWebhooksClient
        """
        return self._raw_client

    async def get(
        self, *, identifiers: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> WebhookResult:
        """
        Retrieve all webhook that are set up to receive events for specific URLs or phone numbers.

        Parameters
        ----------
        identifiers : typing.Sequence[str]
            List of URLs or phone numbers in E.164 format that the webhook is attached to.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WebhookResult
            Returns all webhooks matching the search criteria. <br>

            Results are sorted by ID and duplicates are removed. This identifier is a string that always begins with the prefix `wh_`, for example: `wh_1234567890`.

        Examples
        --------
        import asyncio

        from rcs import AsyncPinnacle

        client = AsyncPinnacle(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.webhooks.get(
                identifiers=[
                    "https://www.pinnacle.sh/payment",
                    "+14155678901",
                    "https://www.pinnacle.sh/sms-callback",
                    "+14153456659",
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(identifiers=identifiers, request_options=request_options)
        return _response.data
