"""Simulator DB login presets.

This module centralizes default database login credentials and destination ports
for known simulators. It is intentionally simple data to avoid coupling.
"""

from typing import Dict, Any

SIM_DB_CONFIGS: Dict[str, Dict[str, Any]] = {
    # PostgreSQL
    "bugsink": {
        "db_type": "postgresql",
        "user": "bugsink",
        "password": "bugsink_password",
        "dest_port": 5432,
        "databases": ["postgres", "bugsink"],
    },
    "calcom": {
        "db_type": "postgresql",
        "user": "unicorn_user",
        "password": "magical_password",
        "dest_port": 5432,
        "databases": ["postgres", "calendso"],
    },
    "discourse": {
        "db_type": "postgresql",
        "user": "discourse",
        "password": "discourse",
        "dest_port": 5432,
        "databases": ["postgres", "discourse"],
    },
    "espocrm": {
        "db_type": "postgresql",
        "user": "espocrm",
        "password": "espocrm",
        "dest_port": 5432,
        "databases": ["postgres", "espocrm"],
    },
    "firefly": {
        "db_type": "postgresql",
        "user": "firefly",
        "password": "password",
        "dest_port": 5432,
        "databases": ["postgres", "firefly"],
    },
    "gitlab": {
        "db_type": "postgresql",
        "user": "gitlab",
        "password": "changeme1234",
        "dest_port": 5432,
        "databases": ["postgres", "gitlabhq_production"],
    },
    "grafana": {
        "db_type": "postgresql",
        "user": "grafanauser",
        "password": "grafanapassword",
        "dest_port": 5432,
        "databases": ["postgres", "grafanadb", "pagila"],
    },
    "listmonk": {
        "db_type": "postgresql",
        "user": "listmonk",
        "password": "listmonk",
        "dest_port": 5432,
        "databases": ["postgres", "listmonk"],
    },
    "mattermost": {
        "db_type": "postgresql",
        "user": "mmuser",
        "password": "mmuser_password",
        "dest_port": 5432,
        "databases": ["postgres", "mattermost"],
    },
    "mealie": {
        "db_type": "postgresql",
        "user": "mealie",
        "password": "mealie",
        "dest_port": 5432,
        "databases": ["postgres", "mealie"],
    },
    "metabase": {
        "db_type": "postgresql",
        "user": "metabase",
        "password": "metabase",
        "dest_port": 5432,
        "databases": ["postgres", "metabase"],
    },
    "moodle": {
        "db_type": "postgresql",
        "user": "moodle",
        "password": "moodle_password",
        "dest_port": 5432,
        "databases": ["postgres", "moodle"],
    },
    # Odoo variants (all PostgreSQL)
    "odoo": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odooattendances": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odoocrm": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odoodatarecycle": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odooelearning": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odooemailmarketing": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odooemployees": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odooevents": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odooexpenses": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odoofleet": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odooinventory": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odooinvoicing": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odoolivechat": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odoolunch": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odoomaintenance": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odoomanufacturing": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odoopos": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odoopurchase": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odoorecruitment": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odoorepairs": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odoorestaurant": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odoosales": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odoosmsmarketing": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odoosurveys": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odootimeoff": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "odootodo": {
        "db_type": "postgresql",
        "user": "odoo",
        "password": "myodoo",
        "dest_port": 5432,
        "databases": ["postgres", "odoo_db"],
    },
    "openproject": {
        "db_type": "postgresql",
        "user": "postgres",
        "password": "p4ssw0rd",
        "dest_port": 5432,
        "databases": ["postgres", "openproject"],
    },
    "outline": {
        "db_type": "postgresql",
        "user": "outline",
        "password": "outline",
        "dest_port": 5432,
        "databases": ["postgres", "outline"],
    },
    "paperless": {
        "db_type": "postgresql",
        "user": "paperless",
        "password": "paperless",
        "dest_port": 5432,
        "databases": ["postgres", "paperless"],
    },
    "roundcube": {
        "db_type": "postgresql",
        "user": "roundcube",
        "password": "roundcube",
        "dest_port": 5432,
        "databases": ["postgres", "dbmail"],
    },
    "taiga": {
        "db_type": "postgresql",
        "user": "taiga",
        "password": "taiga",
        "dest_port": 5432,
        "databases": ["postgres", "taiga"],
    },
    "twenty": {
        "db_type": "postgresql",
        "user": "postgres",
        "password": "mysecurepass123",
        "dest_port": 5432,
        "databases": ["postgres", "default"],
    },
    # MySQL/MariaDB
    "dolibarr": {
        "db_type": "mysql",
        "user": "root",
        "password": "root",
        "dest_port": 3306,
        "databases": ["dolibarr"],
    },
    "frappebuilder": {
        "db_type": "mysql",
        "user": "root",
        "password": "admin",
        "dest_port": 3306,
        "databases": ["admin", "frappebuilder_sim"],
    },
    "frappecrm": {
        "db_type": "mysql",
        "user": "root",
        "password": "admin",
        "dest_port": 3306,
        "databases": ["admin", "frappecrm_sim"],
    },
    "frappeeducation": {
        "db_type": "mysql",
        "user": "root",
        "password": "admin",
        "dest_port": 3306,
        "databases": ["admin", "frappeeducation_sim"],
    },
    "frappeerpnext": {
        "db_type": "mysql",
        "user": "root",
        "password": "admin",
        "dest_port": 3306,
        "databases": ["admin"],
    },
    "frappehelpdesk": {
        "db_type": "mysql",
        "user": "root",
        "password": "admin",
        "dest_port": 3306,
        "databases": ["admin", "frappehelpdesk_sim"],
    },
    "frappeinsights": {
        "db_type": "mysql",
        "user": "root",
        "password": "admin",
        "dest_port": 3306,
        "databases": ["admin", "frappeinsights_sim"],
    },
    "frappelms": {
        "db_type": "mysql",
        "user": "root",
        "password": "admin",
        "dest_port": 3306,
        "databases": ["admin", "frappelms_sim"],
    },
    "frappewiki": {
        "db_type": "mysql",
        "user": "root",
        "password": "admin",
        "dest_port": 3306,
        "databases": ["admin", "frappewiki_sim"],
    },
    "kanboard": {
        "db_type": "mysql",
        "user": "root",
        "password": "secret",
        "dest_port": 3306,
        "databases": ["kanboard"],
    },
    "nextcloud": {
        "db_type": "mysql",
        "user": "root",
        "password": "changeme1234",
        "dest_port": 3306,
        "databases": ["nextcloud"],
    },
    "opencart": {
        "db_type": "mysql",
        "user": "root",
        "password": "bitnami",
        "dest_port": 3306,
        "databases": ["bitnami_opencart"],
    },
    "photoprism": {
        "db_type": "mysql",
        "user": "root",
        "password": "photoprism",
        "dest_port": 3306,
        "databases": ["photoprism"],
    },
    "redmine": {
        "db_type": "mysql",
        "user": "root",
        "password": "example",
        "dest_port": 3306,
        "databases": ["redmine"],
    },
    "snipeit": {
        "db_type": "mysql",
        "user": "root",
        "password": "changeme1234",
        "dest_port": 3306,
        "databases": ["snipeit"],
    },
    "suitecrm": {
        "db_type": "mysql",
        "user": "root",
        "password": "bitnami123",
        "dest_port": 3306,
        "databases": ["bitnami_suitecrm"],
    },
    "vikunja": {
        "db_type": "mysql",
        "user": "root",
        "password": "supersecret",
        "dest_port": 3306,
        "databases": ["vikunja"],
    },
}
