# Contributing to pycoupler

Thank you for your interest in contributing to *pycoupler*, an open-source
Python library for coupling as well as operating LPJmL and processing related
data.
We currently prefer contributions in the form of bug reports, feature requests,
and suggestions of code improvements as issues in the
[pycoupler GitHub repository](https://github.com/PIK-LPJmL/pycoupler/issues).
If you want to contribute code, please follow the instructions below.


## Getting Started

Before you start contributing to *pycoupler*, here are a few steps to get you
set up:

1. Fork the [pycoupler GitHub repository](https://github.com/PIK-LPJmL/pycoupler)
to your own GitHub account.
2. Clone your forked repository to your local machine.
   ```shell
   git clone https://github.com/YourUsername/pycoupler.git
   cd pycoupler
   ```
3. Install the library and its dependencies following the instructions in the
documentation.

Now you're ready to start making contributions!

## Contributing

To contribute to *pycoupler*, please follow these steps:

1. Check for existing issues in the
[**issue tracker**](https://github.com/PIK-LPJmL/pycoupler/issues) to see if
your contribution idea has already been discussed or reported.
2. If the issue doesn't already exist, create a **new issue** to discuss the
problem or feature you want to address. Be sure to provide as much detail as
possible to help others understand the context and purpose.
3. **Fork the repository** if you haven't already and create a **new branch**
for your contribution.
4. Make your changes in that new branch, following best practices and
adhering to the **coding style** of the project.
5. Write **unit tests** if applicable and ensure that all tests pass.
6. Submit a **pull request (PR)** referencing the issue you created earlier.
Describe your changes, and our team will review it as soon as possible.
7. All discussion threads of the PR need to be resolved before the PR can be merged.

Your contributions will be greatly appreciated and will help make *pycoupler*
even better.

## Code Quality
We use the the
[**PEP8 - Style Guide for Python Code**](https://peps.python.org/pep-0008/).

Please make sure that your code passes all tests and static code analysis before
submitting a pull request.

## Code of Conduct

Please note that by contributing to *pycoupler*, you are expected to adhere to
our Code of Conduct. We strive to maintain a welcoming and inclusive community,
and we expect respectful and considerate behavior from all contributors:
* **Be Respectful**: Treat all community members with respect and kindness.
* **Inclusivity**: Ensure that your language and actions are inclusive and
respectful of diversity.
* **Collaboration**: Encourage a collaborative and supportive atmosphere.

We do not tolerate:
* **Harassment**: Any form of harassment, trolling, or offensive behavior.
* **Discrimination**: Discrimination, derogatory comments, or exclusionary
practices.
* **Bullying**: Bullying or aggressive behavior towards others.

Reporting Incidents  
If you witness or experience any violations, please report them to
[jannesbr@pik-potsdam.de](mailto:jannesbr@pik-potsdam.de).
All reports will be handled confidentially and promptly.
