from .datasets import FeaturesConcatDataset, FeaturesDataset
from .decorators import (
    FeatureKind,
    FeaturePredecessor,
    bivariate_feature,
    multivariate_feature,
    univariate_feature,
)
from .extractors import (
    BivariateFeature,
    DirectedBivariateFeature,
    FeatureExtractor,
    MultivariateFeature,
    TrainableFeature,
    UnivariateFeature,
)
from .feature_bank import (  # Complexity; Connectivity; CSP; Dimensionality; Signal; Spectral
    CoherenceFeatureExtractor,
    CommonSpatialPattern,
    DBSpectralFeatureExtractor,
    EntropyFeatureExtractor,
    HilbertFeatureExtractor,
    NormalizedSpectralFeatureExtractor,
    SpectralFeatureExtractor,
    complexity_approx_entropy,
    complexity_lempel_ziv,
    complexity_sample_entropy,
    complexity_svd_entropy,
    connectivity_imaginary_coherence,
    connectivity_lagged_coherence,
    connectivity_magnitude_square_coherence,
    dimensionality_detrended_fluctuation_analysis,
    dimensionality_higuchi_fractal_dim,
    dimensionality_hurst_exp,
    dimensionality_katz_fractal_dim,
    dimensionality_petrosian_fractal_dim,
    signal_decorrelation_time,
    signal_hjorth_activity,
    signal_hjorth_complexity,
    signal_hjorth_mobility,
    signal_kurtosis,
    signal_line_length,
    signal_mean,
    signal_peak_to_peak,
    signal_quantile,
    signal_root_mean_square,
    signal_skewness,
    signal_std,
    signal_variance,
    signal_zero_crossings,
    spectral_bands_power,
    spectral_edge,
    spectral_entropy,
    spectral_hjorth_activity,
    spectral_hjorth_complexity,
    spectral_hjorth_mobility,
    spectral_moment,
    spectral_root_total_power,
    spectral_slope,
)
from .inspect import (
    get_all_feature_extractors,
    get_all_feature_kinds,
    get_all_features,
    get_feature_kind,
    get_feature_predecessors,
)
from .serialization import load_features_concat_dataset
from .utils import extract_features, fit_feature_extractors

__all__ = [
    "FeaturesConcatDataset",
    "FeaturesDataset",
    "FeatureKind",
    "FeaturePredecessor",
    "bivariate_feature",
    "multivariate_feature",
    "univariate_feature",
    "BivariateFeature",
    "DirectedBivariateFeature",
    "FeatureExtractor",
    "MultivariateFeature",
    "TrainableFeature",
    "UnivariateFeature",
    "get_all_feature_extractors",
    "get_all_feature_kinds",
    "get_all_features",
    "get_feature_kind",
    "get_feature_predecessors",
    "load_features_concat_dataset",
    "extract_features",
    "fit_feature_extractors",
    # Feature part
    # Complexity
    "EntropyFeatureExtractor",
    "complexity_approx_entropy",
    "complexity_sample_entropy",
    "complexity_svd_entropy",
    "complexity_lempel_ziv",
    # Connectivity
    "CoherenceFeatureExtractor",
    "connectivity_magnitude_square_coherence",
    "connectivity_imaginary_coherence",
    "connectivity_lagged_coherence",
    # CSP
    "CommonSpatialPattern",
    # Dimensionality
    "dimensionality_higuchi_fractal_dim",
    "dimensionality_petrosian_fractal_dim",
    "dimensionality_katz_fractal_dim",
    "dimensionality_hurst_exp",
    "dimensionality_detrended_fluctuation_analysis",
    # Signal
    "HilbertFeatureExtractor",
    "signal_mean",
    "signal_variance",
    "signal_skewness",
    "signal_kurtosis",
    "signal_std",
    "signal_root_mean_square",
    "signal_peak_to_peak",
    "signal_quantile",
    "signal_zero_crossings",
    "signal_line_length",
    "signal_hjorth_activity",
    "signal_hjorth_mobility",
    "signal_hjorth_complexity",
    "signal_decorrelation_time",
    # Spectral
    "SpectralFeatureExtractor",
    "NormalizedSpectralFeatureExtractor",
    "DBSpectralFeatureExtractor",
    "spectral_root_total_power",
    "spectral_moment",
    "spectral_entropy",
    "spectral_edge",
    "spectral_slope",
    "spectral_bands_power",
    "spectral_hjorth_activity",
    "spectral_hjorth_mobility",
    "spectral_hjorth_complexity",
]


# This import is not working because of the indice
# way of the numba, needs to be improve later.
# TO DO
#
