"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.10
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.admin_status import AdminStatus
from agilicus_api.model.base_upstreams import BaseUpstreams
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.issuer import Issuer
from agilicus_api.model.issuer_client import IssuerClient
from agilicus_api.model.list_issuer_clients_response import ListIssuerClientsResponse
from agilicus_api.model.list_issuer_extensions_response import ListIssuerExtensionsResponse
from agilicus_api.model.list_issuer_roots_response import ListIssuerRootsResponse
from agilicus_api.model.list_issuer_upstreams import ListIssuerUpstreams
from agilicus_api.model.list_policies_response import ListPoliciesResponse
from agilicus_api.model.list_policy_rules_response import ListPolicyRulesResponse
from agilicus_api.model.list_upstream_aliases import ListUpstreamAliases
from agilicus_api.model.list_upstream_group_mapping import ListUpstreamGroupMapping
from agilicus_api.model.list_well_known_issuer_info import ListWellKnownIssuerInfo
from agilicus_api.model.policy import Policy
from agilicus_api.model.policy_rule import PolicyRule
from agilicus_api.model.policy_spec import PolicySpec
from agilicus_api.model.reset_policy_request import ResetPolicyRequest
from agilicus_api.model.service_account_reset_body import ServiceAccountResetBody
from agilicus_api.model.upstream_alias import UpstreamAlias
from agilicus_api.model.upstream_group_mapping import UpstreamGroupMapping
from agilicus_api.model.well_known_issuer_info import WellKnownIssuerInfo


class IssuersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_client(
            self,
            issuer_client,
            **kwargs
        ):
            """Create a client  # noqa: E501

            Create a client  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_client(issuer_client, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_client (IssuerClient): IssuerClient

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IssuerClient
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_client'] = \
                issuer_client
            return self.call_with_http_info(**kwargs)

        if self.create_client is None:
            self.create_client = _Endpoint(
                settings={
                    'response_type': (IssuerClient,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/clients',
                    'operation_id': 'create_client',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_client',
                    ],
                    'required': [
                        'issuer_client',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_client':
                            (IssuerClient,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'issuer_client': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_client
            )

        def __create_issuer(
            self,
            issuer,
            **kwargs
        ):
            """Create an issuer  # noqa: E501

            Create an issuer  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_issuer(issuer, async_req=True)
            >>> result = thread.get()

            Args:
                issuer (Issuer): Issuer

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Issuer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer'] = \
                issuer
            return self.call_with_http_info(**kwargs)

        if self.create_issuer is None:
            self.create_issuer = _Endpoint(
                settings={
                    'response_type': (Issuer,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_roots',
                    'operation_id': 'create_issuer',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer',
                    ],
                    'required': [
                        'issuer',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer':
                            (Issuer,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'issuer': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_issuer
            )

        def __create_policy(
            self,
            policy,
            **kwargs
        ):
            """Create a policy  # noqa: E501

            Create a policy  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_policy(policy, async_req=True)
            >>> result = thread.get()

            Args:
                policy (Policy): Policy

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Policy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy'] = \
                policy
            return self.call_with_http_info(**kwargs)

        if self.create_policy is None:
            self.create_policy = _Endpoint(
                settings={
                    'response_type': (Policy,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/authentication_policies',
                    'operation_id': 'create_policy',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'policy',
                    ],
                    'required': [
                        'policy',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'policy':
                            (Policy,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'policy': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_policy
            )

        def __create_policy_rule(
            self,
            policy_id,
            policy_rule,
            **kwargs
        ):
            """Create a policy rule  # noqa: E501

            Create a policy rule  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_policy_rule(policy_id, policy_rule, async_req=True)
            >>> result = thread.get()

            Args:
                policy_id (str): Policy Unique identifier
                policy_rule (PolicyRule): Policy rule

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PolicyRule
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_id'] = \
                policy_id
            kwargs['policy_rule'] = \
                policy_rule
            return self.call_with_http_info(**kwargs)

        if self.create_policy_rule is None:
            self.create_policy_rule = _Endpoint(
                settings={
                    'response_type': (PolicyRule,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/authentication_policies/{policy_id}/policy_rules',
                    'operation_id': 'create_policy_rule',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'policy_id',
                        'policy_rule',
                    ],
                    'required': [
                        'policy_id',
                        'policy_rule',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'policy_id':
                            (str,),
                        'policy_rule':
                            (PolicyRule,),
                    },
                    'attribute_map': {
                        'policy_id': 'policy_id',
                    },
                    'location_map': {
                        'policy_id': 'path',
                        'policy_rule': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_policy_rule
            )

        def __create_upstream_alias(
            self,
            issuer_id,
            upstream_alias,
            **kwargs
        ):
            """Create an upstream alias  # noqa: E501

            Create an upstream alias  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_upstream_alias(issuer_id, upstream_alias, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path
                upstream_alias (UpstreamAlias): Upstream alias

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpstreamAlias
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            kwargs['upstream_alias'] = \
                upstream_alias
            return self.call_with_http_info(**kwargs)

        if self.create_upstream_alias is None:
            self.create_upstream_alias = _Endpoint(
                settings={
                    'response_type': (UpstreamAlias,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions/{issuer_id}/upstream_aliases',
                    'operation_id': 'create_upstream_alias',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'upstream_alias',
                    ],
                    'required': [
                        'issuer_id',
                        'upstream_alias',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'upstream_alias':
                            (UpstreamAlias,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'upstream_alias': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_upstream_alias
            )

        def __create_upstream_group_mapping(
            self,
            issuer_id,
            upstream_group_mapping,
            **kwargs
        ):
            """Create an upstream group mapping  # noqa: E501

            Create an upstream group mapping  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_upstream_group_mapping(issuer_id, upstream_group_mapping, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path
                upstream_group_mapping (UpstreamGroupMapping): Upstream Group Mapping

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpstreamGroupMapping
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            kwargs['upstream_group_mapping'] = \
                upstream_group_mapping
            return self.call_with_http_info(**kwargs)

        if self.create_upstream_group_mapping is None:
            self.create_upstream_group_mapping = _Endpoint(
                settings={
                    'response_type': (UpstreamGroupMapping,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions/{issuer_id}/upstream_group_mapping',
                    'operation_id': 'create_upstream_group_mapping',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'upstream_group_mapping',
                    ],
                    'required': [
                        'issuer_id',
                        'upstream_group_mapping',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'upstream_group_mapping':
                            (UpstreamGroupMapping,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'upstream_group_mapping': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_upstream_group_mapping
            )

        def __delete_client(
            self,
            client_id,
            **kwargs
        ):
            """Delete a client  # noqa: E501

            Delete a client  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_client(client_id, async_req=True)
            >>> result = thread.get()

            Args:
                client_id (str): client_id path

            Keyword Args:
                summarize_collection (bool): Restrict the results to the summary. Individual collections define what content to include in the summary. [optional] if omitted the server will use the default value of True
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['client_id'] = \
                client_id
            return self.call_with_http_info(**kwargs)

        if self.delete_client is None:
            self.delete_client = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/clients/{client_id}',
                    'operation_id': 'delete_client',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'client_id',
                        'summarize_collection',
                        'org_id',
                    ],
                    'required': [
                        'client_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'client_id':
                            (str,),
                        'summarize_collection':
                            (bool,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'client_id': 'client_id',
                        'summarize_collection': 'summarize_collection',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'client_id': 'path',
                        'summarize_collection': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_client
            )

        def __delete_policy(
            self,
            policy_id,
            **kwargs
        ):
            """Delete a Policy  # noqa: E501

            Delete a Policy  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_policy(policy_id, async_req=True)
            >>> result = thread.get()

            Args:
                policy_id (str): Policy Unique identifier

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_id'] = \
                policy_id
            return self.call_with_http_info(**kwargs)

        if self.delete_policy is None:
            self.delete_policy = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/authentication_policies/{policy_id}',
                    'operation_id': 'delete_policy',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'policy_id',
                        'org_id',
                    ],
                    'required': [
                        'policy_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'policy_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'policy_id': 'policy_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'policy_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_policy
            )

        def __delete_policy_rule(
            self,
            policy_id,
            policy_rule_id,
            **kwargs
        ):
            """Delete a Policy Rule  # noqa: E501

            Delete a Policy Rule  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_policy_rule(policy_id, policy_rule_id, async_req=True)
            >>> result = thread.get()

            Args:
                policy_id (str): Policy Unique identifier
                policy_rule_id (str): Policy Rule Unique identifier

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_id'] = \
                policy_id
            kwargs['policy_rule_id'] = \
                policy_rule_id
            return self.call_with_http_info(**kwargs)

        if self.delete_policy_rule is None:
            self.delete_policy_rule = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/authentication_policies/{policy_id}/policy_rules/{policy_rule_id}',
                    'operation_id': 'delete_policy_rule',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'policy_id',
                        'policy_rule_id',
                        'org_id',
                    ],
                    'required': [
                        'policy_id',
                        'policy_rule_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'policy_id':
                            (str,),
                        'policy_rule_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'policy_id': 'policy_id',
                        'policy_rule_id': 'policy_rule_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'policy_id': 'path',
                        'policy_rule_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_policy_rule
            )

        def __delete_root(
            self,
            issuer_id,
            **kwargs
        ):
            """Delete an Issuer  # noqa: E501

            Delete an Issuer  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_root(issuer_id, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path

            Keyword Args:
                summarize_collection (bool): Restrict the results to the summary. Individual collections define what content to include in the summary. [optional] if omitted the server will use the default value of True
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            return self.call_with_http_info(**kwargs)

        if self.delete_root is None:
            self.delete_root = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_roots/{issuer_id}',
                    'operation_id': 'delete_root',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'summarize_collection',
                        'org_id',
                    ],
                    'required': [
                        'issuer_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'summarize_collection':
                            (bool,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                        'summarize_collection': 'summarize_collection',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'summarize_collection': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_root
            )

        def __delete_upstream_alias(
            self,
            issuer_id,
            upstream_alias_id,
            **kwargs
        ):
            """Delete an upstream alias  # noqa: E501

            Delete an upstream alias  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_upstream_alias(issuer_id, upstream_alias_id, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path
                upstream_alias_id (str): upstream alias id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            kwargs['upstream_alias_id'] = \
                upstream_alias_id
            return self.call_with_http_info(**kwargs)

        if self.delete_upstream_alias is None:
            self.delete_upstream_alias = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions/{issuer_id}/upstream_aliases/{upstream_alias_id}',
                    'operation_id': 'delete_upstream_alias',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'upstream_alias_id',
                        'org_id',
                    ],
                    'required': [
                        'issuer_id',
                        'upstream_alias_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'upstream_alias_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                        'upstream_alias_id': 'upstream_alias_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'upstream_alias_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_upstream_alias
            )

        def __delete_upstream_group_mapping(
            self,
            issuer_id,
            upstream_group_mapping_id,
            **kwargs
        ):
            """Delete an upstream group mapping  # noqa: E501

            Delete an upstream group mapping  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_upstream_group_mapping(issuer_id, upstream_group_mapping_id, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path
                upstream_group_mapping_id (str): upstream group_mapping id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            kwargs['upstream_group_mapping_id'] = \
                upstream_group_mapping_id
            return self.call_with_http_info(**kwargs)

        if self.delete_upstream_group_mapping is None:
            self.delete_upstream_group_mapping = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions/{issuer_id}/upstream_group_mapping/{upstream_group_mapping_id}',
                    'operation_id': 'delete_upstream_group_mapping',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'upstream_group_mapping_id',
                        'org_id',
                    ],
                    'required': [
                        'issuer_id',
                        'upstream_group_mapping_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'upstream_group_mapping_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                        'upstream_group_mapping_id': 'upstream_group_mapping_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'upstream_group_mapping_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_upstream_group_mapping
            )

        def __get_client(
            self,
            client_id,
            **kwargs
        ):
            """Get a client  # noqa: E501

            Get a client  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_client(client_id, async_req=True)
            >>> result = thread.get()

            Args:
                client_id (str): client_id path

            Keyword Args:
                summarize_collection (bool): Restrict the results to the summary. Individual collections define what content to include in the summary. [optional] if omitted the server will use the default value of True
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IssuerClient
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['client_id'] = \
                client_id
            return self.call_with_http_info(**kwargs)

        if self.get_client is None:
            self.get_client = _Endpoint(
                settings={
                    'response_type': (IssuerClient,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/clients/{client_id}',
                    'operation_id': 'get_client',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'client_id',
                        'summarize_collection',
                        'org_id',
                    ],
                    'required': [
                        'client_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'client_id':
                            (str,),
                        'summarize_collection':
                            (bool,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'client_id': 'client_id',
                        'summarize_collection': 'summarize_collection',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'client_id': 'path',
                        'summarize_collection': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_client
            )

        def __get_issuer(
            self,
            issuer_id,
            **kwargs
        ):
            """Get an issuer  # noqa: E501

            Get an issuer  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_issuer(issuer_id, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path

            Keyword Args:
                summarize_collection (bool): Restrict the results to the summary. Individual collections define what content to include in the summary. [optional] if omitted the server will use the default value of True
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Issuer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            return self.call_with_http_info(**kwargs)

        if self.get_issuer is None:
            self.get_issuer = _Endpoint(
                settings={
                    'response_type': (Issuer,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions/{issuer_id}',
                    'operation_id': 'get_issuer',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'summarize_collection',
                        'org_id',
                    ],
                    'required': [
                        'issuer_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'summarize_collection':
                            (bool,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                        'summarize_collection': 'summarize_collection',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'summarize_collection': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_issuer
            )

        def __get_policy(
            self,
            policy_id,
            **kwargs
        ):
            """Get a policy  # noqa: E501

            Get a policy  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_policy(policy_id, async_req=True)
            >>> result = thread.get()

            Args:
                policy_id (str): Policy Unique identifier

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Policy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_id'] = \
                policy_id
            return self.call_with_http_info(**kwargs)

        if self.get_policy is None:
            self.get_policy = _Endpoint(
                settings={
                    'response_type': (Policy,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/authentication_policies/{policy_id}',
                    'operation_id': 'get_policy',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'policy_id',
                        'org_id',
                    ],
                    'required': [
                        'policy_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'policy_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'policy_id': 'policy_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'policy_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_policy
            )

        def __get_policy_rule(
            self,
            policy_id,
            policy_rule_id,
            **kwargs
        ):
            """Get a policy rule  # noqa: E501

            Get a policy rule  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_policy_rule(policy_id, policy_rule_id, async_req=True)
            >>> result = thread.get()

            Args:
                policy_id (str): Policy Unique identifier
                policy_rule_id (str): Policy Rule Unique identifier

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PolicyRule
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_id'] = \
                policy_id
            kwargs['policy_rule_id'] = \
                policy_rule_id
            return self.call_with_http_info(**kwargs)

        if self.get_policy_rule is None:
            self.get_policy_rule = _Endpoint(
                settings={
                    'response_type': (PolicyRule,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/authentication_policies/{policy_id}/policy_rules/{policy_rule_id}',
                    'operation_id': 'get_policy_rule',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'policy_id',
                        'policy_rule_id',
                        'org_id',
                    ],
                    'required': [
                        'policy_id',
                        'policy_rule_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'policy_id':
                            (str,),
                        'policy_rule_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'policy_id': 'policy_id',
                        'policy_rule_id': 'policy_rule_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'policy_id': 'path',
                        'policy_rule_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_policy_rule
            )

        def __get_root(
            self,
            issuer_id,
            **kwargs
        ):
            """Get an issuer  # noqa: E501

            Get an issuer  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_root(issuer_id, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path

            Keyword Args:
                summarize_collection (bool): Restrict the results to the summary. Individual collections define what content to include in the summary. [optional] if omitted the server will use the default value of True
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Issuer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            return self.call_with_http_info(**kwargs)

        if self.get_root is None:
            self.get_root = _Endpoint(
                settings={
                    'response_type': (Issuer,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_roots/{issuer_id}',
                    'operation_id': 'get_root',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'summarize_collection',
                        'org_id',
                    ],
                    'required': [
                        'issuer_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'summarize_collection':
                            (bool,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                        'summarize_collection': 'summarize_collection',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'summarize_collection': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_root
            )

        def __get_upstream_alias(
            self,
            issuer_id,
            upstream_alias_id,
            **kwargs
        ):
            """Get an upstream alias  # noqa: E501

            Get an upstream alias  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_upstream_alias(issuer_id, upstream_alias_id, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path
                upstream_alias_id (str): upstream alias id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpstreamAlias
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            kwargs['upstream_alias_id'] = \
                upstream_alias_id
            return self.call_with_http_info(**kwargs)

        if self.get_upstream_alias is None:
            self.get_upstream_alias = _Endpoint(
                settings={
                    'response_type': (UpstreamAlias,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions/{issuer_id}/upstream_aliases/{upstream_alias_id}',
                    'operation_id': 'get_upstream_alias',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'upstream_alias_id',
                        'org_id',
                    ],
                    'required': [
                        'issuer_id',
                        'upstream_alias_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'upstream_alias_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                        'upstream_alias_id': 'upstream_alias_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'upstream_alias_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_upstream_alias
            )

        def __get_upstream_group_mapping(
            self,
            issuer_id,
            upstream_group_mapping_id,
            **kwargs
        ):
            """Get an upstream group mapping  # noqa: E501

            Get an upstream group mapping  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_upstream_group_mapping(issuer_id, upstream_group_mapping_id, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path
                upstream_group_mapping_id (str): upstream group_mapping id

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpstreamGroupMapping
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            kwargs['upstream_group_mapping_id'] = \
                upstream_group_mapping_id
            return self.call_with_http_info(**kwargs)

        if self.get_upstream_group_mapping is None:
            self.get_upstream_group_mapping = _Endpoint(
                settings={
                    'response_type': (UpstreamGroupMapping,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions/{issuer_id}/upstream_group_mapping/{upstream_group_mapping_id}',
                    'operation_id': 'get_upstream_group_mapping',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'upstream_group_mapping_id',
                        'org_id',
                    ],
                    'required': [
                        'issuer_id',
                        'upstream_group_mapping_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'upstream_group_mapping_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                        'upstream_group_mapping_id': 'upstream_group_mapping_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'upstream_group_mapping_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_upstream_group_mapping
            )

        def __get_upstreams(
            self,
            issuer_id,
            org_id,
            **kwargs
        ):
            """Get provisioned upstreams for the issuer  # noqa: E501

            Get provisioned upstreams for the issuer  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_upstreams(issuer_id, org_id, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path
                org_id (str): Organisation Unique identifier

            Keyword Args:
                upstream_type (str): The type of issuer upstream to query on. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BaseUpstreams
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.get_upstreams is None:
            self.get_upstreams = _Endpoint(
                settings={
                    'response_type': (BaseUpstreams,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions/{issuer_id}/upstreams',
                    'operation_id': 'get_upstreams',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'org_id',
                        'upstream_type',
                    ],
                    'required': [
                        'issuer_id',
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'org_id':
                            (str,),
                        'upstream_type':
                            (str,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                        'org_id': 'org_id',
                        'upstream_type': 'upstream_type',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'org_id': 'query',
                        'upstream_type': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_upstreams
            )

        def __get_wellknown_issuer_info(
            self,
            issuer_id,
            **kwargs
        ):
            """Get well-known issuer information  # noqa: E501

            Get well-known issuer information  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_wellknown_issuer_info(issuer_id, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                WellKnownIssuerInfo
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            return self.call_with_http_info(**kwargs)

        if self.get_wellknown_issuer_info is None:
            self.get_wellknown_issuer_info = _Endpoint(
                settings={
                    'response_type': (WellKnownIssuerInfo,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions/{issuer_id}/well_known_info',
                    'operation_id': 'get_wellknown_issuer_info',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                    ],
                    'required': [
                        'issuer_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_wellknown_issuer_info
            )

        def __list_clients(
            self,
            **kwargs
        ):
            """Query Clients  # noqa: E501

            Query Clients  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_clients(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                summarize_collection (bool): Restrict the results to the summary. Individual collections define what content to include in the summary. [optional] if omitted the server will use the default value of True
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                admin_status (AdminStatus): admin status query. [optional]
                show_deleted (bool): Allows overriding certain queries in the system to show deleted objects.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListIssuerClientsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_clients is None:
            self.list_clients = _Endpoint(
                settings={
                    'response_type': (ListIssuerClientsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/clients',
                    'operation_id': 'list_clients',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'summarize_collection',
                        'limit',
                        'org_id',
                        'admin_status',
                        'show_deleted',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'summarize_collection':
                            (bool,),
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'admin_status':
                            (AdminStatus,),
                        'show_deleted':
                            (bool,),
                    },
                    'attribute_map': {
                        'summarize_collection': 'summarize_collection',
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'admin_status': 'admin_status',
                        'show_deleted': 'show_deleted',
                    },
                    'location_map': {
                        'summarize_collection': 'query',
                        'limit': 'query',
                        'org_id': 'query',
                        'admin_status': 'query',
                        'show_deleted': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_clients
            )

        def __list_issuer_roots(
            self,
            **kwargs
        ):
            """Query Issuers  # noqa: E501

            Query Issuers  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_issuer_roots(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                summarize_collection (bool): Restrict the results to the summary. Individual collections define what content to include in the summary. [optional] if omitted the server will use the default value of True
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                issuer (str): Organisation issuer. [optional]
                admin_status (AdminStatus): admin status query. [optional]
                show_deleted (bool): Allows overriding certain queries in the system to show deleted objects.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListIssuerRootsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_issuer_roots is None:
            self.list_issuer_roots = _Endpoint(
                settings={
                    'response_type': (ListIssuerRootsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_roots',
                    'operation_id': 'list_issuer_roots',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'summarize_collection',
                        'limit',
                        'issuer',
                        'admin_status',
                        'show_deleted',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'summarize_collection':
                            (bool,),
                        'limit':
                            (int,),
                        'issuer':
                            (str,),
                        'admin_status':
                            (AdminStatus,),
                        'show_deleted':
                            (bool,),
                    },
                    'attribute_map': {
                        'summarize_collection': 'summarize_collection',
                        'limit': 'limit',
                        'issuer': 'issuer',
                        'admin_status': 'admin_status',
                        'show_deleted': 'show_deleted',
                    },
                    'location_map': {
                        'summarize_collection': 'query',
                        'limit': 'query',
                        'issuer': 'query',
                        'admin_status': 'query',
                        'show_deleted': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_issuer_roots
            )

        def __list_issuer_upstreams(
            self,
            **kwargs
        ):
            """list issuer upstream information  # noqa: E501

            list issuer upstream information  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_issuer_upstreams(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                upstream_type (str): The type of issuer upstream to query on. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                admin_status (AdminStatus): admin status query. [optional]
                show_deleted (bool): Allows overriding certain queries in the system to show deleted objects.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListIssuerUpstreams
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_issuer_upstreams is None:
            self.list_issuer_upstreams = _Endpoint(
                settings={
                    'response_type': (ListIssuerUpstreams,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuer_upstreams',
                    'operation_id': 'list_issuer_upstreams',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'upstream_type',
                        'org_id',
                        'limit',
                        'admin_status',
                        'show_deleted',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'upstream_type':
                            (str,),
                        'org_id':
                            (str,),
                        'limit':
                            (int,),
                        'admin_status':
                            (AdminStatus,),
                        'show_deleted':
                            (bool,),
                    },
                    'attribute_map': {
                        'upstream_type': 'upstream_type',
                        'org_id': 'org_id',
                        'limit': 'limit',
                        'admin_status': 'admin_status',
                        'show_deleted': 'show_deleted',
                    },
                    'location_map': {
                        'upstream_type': 'query',
                        'org_id': 'query',
                        'limit': 'query',
                        'admin_status': 'query',
                        'show_deleted': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_issuer_upstreams
            )

        def __list_issuers(
            self,
            **kwargs
        ):
            """Query Issuers  # noqa: E501

            Query Issuers  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_issuers(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                summarize_collection (bool): Restrict the results to the summary. Individual collections define what content to include in the summary. [optional] if omitted the server will use the default value of True
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                issuer (str): Organisation issuer. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                admin_status (AdminStatus): admin status query. [optional]
                show_deleted (bool): Allows overriding certain queries in the system to show deleted objects.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListIssuerExtensionsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_issuers is None:
            self.list_issuers = _Endpoint(
                settings={
                    'response_type': (ListIssuerExtensionsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions',
                    'operation_id': 'list_issuers',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'summarize_collection',
                        'limit',
                        'issuer',
                        'org_id',
                        'admin_status',
                        'show_deleted',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'summarize_collection':
                            (bool,),
                        'limit':
                            (int,),
                        'issuer':
                            (str,),
                        'org_id':
                            (str,),
                        'admin_status':
                            (AdminStatus,),
                        'show_deleted':
                            (bool,),
                    },
                    'attribute_map': {
                        'summarize_collection': 'summarize_collection',
                        'limit': 'limit',
                        'issuer': 'issuer',
                        'org_id': 'org_id',
                        'admin_status': 'admin_status',
                        'show_deleted': 'show_deleted',
                    },
                    'location_map': {
                        'summarize_collection': 'query',
                        'limit': 'query',
                        'issuer': 'query',
                        'org_id': 'query',
                        'admin_status': 'query',
                        'show_deleted': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_issuers
            )

        def __list_policies(
            self,
            **kwargs
        ):
            """Query Policies  # noqa: E501

            Query Policies  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_policies(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                issuer_id (str): Organisation issuer id. [optional]
                policy_name (str): Query the policies by name. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListPoliciesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_policies is None:
            self.list_policies = _Endpoint(
                settings={
                    'response_type': (ListPoliciesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/authentication_policies',
                    'operation_id': 'list_policies',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'org_id',
                        'issuer_id',
                        'policy_name',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                        'issuer_id':
                            (str,),
                        'policy_name':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'org_id': 'org_id',
                        'issuer_id': 'issuer_id',
                        'policy_name': 'policy_name',
                    },
                    'location_map': {
                        'limit': 'query',
                        'org_id': 'query',
                        'issuer_id': 'query',
                        'policy_name': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_policies
            )

        def __list_policy_rules(
            self,
            policy_id,
            **kwargs
        ):
            """Query Policy rules  # noqa: E501

            Query Policy rules  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_policy_rules(policy_id, async_req=True)
            >>> result = thread.get()

            Args:
                policy_id (str): Policy Unique identifier

            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListPolicyRulesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_id'] = \
                policy_id
            return self.call_with_http_info(**kwargs)

        if self.list_policy_rules is None:
            self.list_policy_rules = _Endpoint(
                settings={
                    'response_type': (ListPolicyRulesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/authentication_policies/{policy_id}/policy_rules',
                    'operation_id': 'list_policy_rules',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'policy_id',
                        'limit',
                        'org_id',
                    ],
                    'required': [
                        'policy_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'policy_id':
                            (str,),
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'policy_id': 'policy_id',
                        'limit': 'limit',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'policy_id': 'path',
                        'limit': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_policy_rules
            )

        def __list_upstream_aliases(
            self,
            issuer_id,
            **kwargs
        ):
            """Query upstream aliases for an issuer  # noqa: E501

            Query upstream aliases for an issuer  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_upstream_aliases(issuer_id, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path

            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListUpstreamAliases
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            return self.call_with_http_info(**kwargs)

        if self.list_upstream_aliases is None:
            self.list_upstream_aliases = _Endpoint(
                settings={
                    'response_type': (ListUpstreamAliases,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions/{issuer_id}/upstream_aliases',
                    'operation_id': 'list_upstream_aliases',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'limit',
                        'org_id',
                    ],
                    'required': [
                        'issuer_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                        'limit': 'limit',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'limit': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_upstream_aliases
            )

        def __list_upstream_group_mappings(
            self,
            issuer_id,
            **kwargs
        ):
            """Query upstream group mappings for an issuer  # noqa: E501

            Query upstream group mappings for an issuer  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_upstream_group_mappings(issuer_id, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path

            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListUpstreamGroupMapping
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            return self.call_with_http_info(**kwargs)

        if self.list_upstream_group_mappings is None:
            self.list_upstream_group_mappings = _Endpoint(
                settings={
                    'response_type': (ListUpstreamGroupMapping,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions/{issuer_id}/upstream_group_mapping',
                    'operation_id': 'list_upstream_group_mappings',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'limit',
                        'org_id',
                    ],
                    'required': [
                        'issuer_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'limit':
                            (int,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                        'limit': 'limit',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'limit': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_upstream_group_mappings
            )

        def __list_wellknown_issuer_info(
            self,
            **kwargs
        ):
            """list well-known issuer information  # noqa: E501

            list well-known issuer information  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_wellknown_issuer_info(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                issuer_id (str): Organisation issuer id. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListWellKnownIssuerInfo
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_wellknown_issuer_info is None:
            self.list_wellknown_issuer_info = _Endpoint(
                settings={
                    'response_type': (ListWellKnownIssuerInfo,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions/well_known_info',
                    'operation_id': 'list_wellknown_issuer_info',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'issuer_id',
                        'limit',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'issuer_id':
                            (str,),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'issuer_id': 'issuer_id',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'issuer_id': 'query',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_wellknown_issuer_info
            )

        def __replace_client(
            self,
            client_id,
            issuer_client,
            **kwargs
        ):
            """Update a client  # noqa: E501

            Update a client  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_client(client_id, issuer_client, async_req=True)
            >>> result = thread.get()

            Args:
                client_id (str): client_id path
                issuer_client (IssuerClient): Issuer client

            Keyword Args:
                summarize_collection (bool): Restrict the results to the summary. Individual collections define what content to include in the summary. [optional] if omitted the server will use the default value of True
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IssuerClient
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['client_id'] = \
                client_id
            kwargs['issuer_client'] = \
                issuer_client
            return self.call_with_http_info(**kwargs)

        if self.replace_client is None:
            self.replace_client = _Endpoint(
                settings={
                    'response_type': (IssuerClient,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/clients/{client_id}',
                    'operation_id': 'replace_client',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'client_id',
                        'issuer_client',
                        'summarize_collection',
                    ],
                    'required': [
                        'client_id',
                        'issuer_client',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'client_id':
                            (str,),
                        'issuer_client':
                            (IssuerClient,),
                        'summarize_collection':
                            (bool,),
                    },
                    'attribute_map': {
                        'client_id': 'client_id',
                        'summarize_collection': 'summarize_collection',
                    },
                    'location_map': {
                        'client_id': 'path',
                        'issuer_client': 'body',
                        'summarize_collection': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_client
            )

        def __replace_issuer(
            self,
            issuer_id,
            issuer,
            **kwargs
        ):
            """Update an issuer  # noqa: E501

            Update an issuer  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_issuer(issuer_id, issuer, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path
                issuer (Issuer): Issuer

            Keyword Args:
                summarize_collection (bool): Restrict the results to the summary. Individual collections define what content to include in the summary. [optional] if omitted the server will use the default value of True
                force_reconcile_theme (bool): Forces reconciling the theme file, even if no change was made. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Issuer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            kwargs['issuer'] = \
                issuer
            return self.call_with_http_info(**kwargs)

        if self.replace_issuer is None:
            self.replace_issuer = _Endpoint(
                settings={
                    'response_type': (Issuer,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions/{issuer_id}',
                    'operation_id': 'replace_issuer',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'issuer',
                        'summarize_collection',
                        'force_reconcile_theme',
                    ],
                    'required': [
                        'issuer_id',
                        'issuer',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'issuer':
                            (Issuer,),
                        'summarize_collection':
                            (bool,),
                        'force_reconcile_theme':
                            (bool,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                        'summarize_collection': 'summarize_collection',
                        'force_reconcile_theme': 'force_reconcile_theme',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'issuer': 'body',
                        'summarize_collection': 'query',
                        'force_reconcile_theme': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_issuer
            )

        def __replace_policy(
            self,
            policy_id,
            policy,
            **kwargs
        ):
            """Update a policy  # noqa: E501

            Update a policy  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_policy(policy_id, policy, async_req=True)
            >>> result = thread.get()

            Args:
                policy_id (str): Policy Unique identifier
                policy (Policy): Policy

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Policy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_id'] = \
                policy_id
            kwargs['policy'] = \
                policy
            return self.call_with_http_info(**kwargs)

        if self.replace_policy is None:
            self.replace_policy = _Endpoint(
                settings={
                    'response_type': (Policy,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/authentication_policies/{policy_id}',
                    'operation_id': 'replace_policy',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'policy_id',
                        'policy',
                    ],
                    'required': [
                        'policy_id',
                        'policy',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'policy_id':
                            (str,),
                        'policy':
                            (Policy,),
                    },
                    'attribute_map': {
                        'policy_id': 'policy_id',
                    },
                    'location_map': {
                        'policy_id': 'path',
                        'policy': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_policy
            )

        def __replace_policy_rule(
            self,
            policy_id,
            policy_rule_id,
            policy_rule,
            **kwargs
        ):
            """Update a policy rule  # noqa: E501

            Update a policy rule  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_policy_rule(policy_id, policy_rule_id, policy_rule, async_req=True)
            >>> result = thread.get()

            Args:
                policy_id (str): Policy Unique identifier
                policy_rule_id (str): Policy Rule Unique identifier
                policy_rule (PolicyRule): Policy Rule

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PolicyRule
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_id'] = \
                policy_id
            kwargs['policy_rule_id'] = \
                policy_rule_id
            kwargs['policy_rule'] = \
                policy_rule
            return self.call_with_http_info(**kwargs)

        if self.replace_policy_rule is None:
            self.replace_policy_rule = _Endpoint(
                settings={
                    'response_type': (PolicyRule,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/authentication_policies/{policy_id}/policy_rules/{policy_rule_id}',
                    'operation_id': 'replace_policy_rule',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'policy_id',
                        'policy_rule_id',
                        'policy_rule',
                    ],
                    'required': [
                        'policy_id',
                        'policy_rule_id',
                        'policy_rule',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'policy_id':
                            (str,),
                        'policy_rule_id':
                            (str,),
                        'policy_rule':
                            (PolicyRule,),
                    },
                    'attribute_map': {
                        'policy_id': 'policy_id',
                        'policy_rule_id': 'policy_rule_id',
                    },
                    'location_map': {
                        'policy_id': 'path',
                        'policy_rule_id': 'path',
                        'policy_rule': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_policy_rule
            )

        def __replace_root(
            self,
            issuer_id,
            issuer,
            **kwargs
        ):
            """Update an issuer  # noqa: E501

            Update an issuer  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_root(issuer_id, issuer, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path
                issuer (Issuer): Issuer

            Keyword Args:
                summarize_collection (bool): Restrict the results to the summary. Individual collections define what content to include in the summary. [optional] if omitted the server will use the default value of True
                org_id (str): Organisation Unique identifier. [optional]
                force_reconcile_theme (bool): Forces reconciling the theme file, even if no change was made. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Issuer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            kwargs['issuer'] = \
                issuer
            return self.call_with_http_info(**kwargs)

        if self.replace_root is None:
            self.replace_root = _Endpoint(
                settings={
                    'response_type': (Issuer,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_roots/{issuer_id}',
                    'operation_id': 'replace_root',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'issuer',
                        'summarize_collection',
                        'org_id',
                        'force_reconcile_theme',
                    ],
                    'required': [
                        'issuer_id',
                        'issuer',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'issuer':
                            (Issuer,),
                        'summarize_collection':
                            (bool,),
                        'org_id':
                            (str,),
                        'force_reconcile_theme':
                            (bool,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                        'summarize_collection': 'summarize_collection',
                        'org_id': 'org_id',
                        'force_reconcile_theme': 'force_reconcile_theme',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'issuer': 'body',
                        'summarize_collection': 'query',
                        'org_id': 'query',
                        'force_reconcile_theme': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_root
            )

        def __replace_upstream_alias(
            self,
            issuer_id,
            upstream_alias_id,
            upstream_alias,
            **kwargs
        ):
            """Update an upstream alias  # noqa: E501

            Update an upstream alias  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_upstream_alias(issuer_id, upstream_alias_id, upstream_alias, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path
                upstream_alias_id (str): upstream alias id
                upstream_alias (UpstreamAlias): Issuer upstream alias

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpstreamAlias
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            kwargs['upstream_alias_id'] = \
                upstream_alias_id
            kwargs['upstream_alias'] = \
                upstream_alias
            return self.call_with_http_info(**kwargs)

        if self.replace_upstream_alias is None:
            self.replace_upstream_alias = _Endpoint(
                settings={
                    'response_type': (UpstreamAlias,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions/{issuer_id}/upstream_aliases/{upstream_alias_id}',
                    'operation_id': 'replace_upstream_alias',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'upstream_alias_id',
                        'upstream_alias',
                    ],
                    'required': [
                        'issuer_id',
                        'upstream_alias_id',
                        'upstream_alias',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'upstream_alias_id':
                            (str,),
                        'upstream_alias':
                            (UpstreamAlias,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                        'upstream_alias_id': 'upstream_alias_id',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'upstream_alias_id': 'path',
                        'upstream_alias': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_upstream_alias
            )

        def __replace_upstream_group_mapping(
            self,
            issuer_id,
            upstream_group_mapping_id,
            upstream_group_mapping,
            **kwargs
        ):
            """Update an upstream group mapping  # noqa: E501

            Update an upstream group mapping  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_upstream_group_mapping(issuer_id, upstream_group_mapping_id, upstream_group_mapping, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path
                upstream_group_mapping_id (str): upstream group_mapping id
                upstream_group_mapping (UpstreamGroupMapping): Issuer upstream group mapping

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpstreamGroupMapping
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            kwargs['upstream_group_mapping_id'] = \
                upstream_group_mapping_id
            kwargs['upstream_group_mapping'] = \
                upstream_group_mapping
            return self.call_with_http_info(**kwargs)

        if self.replace_upstream_group_mapping is None:
            self.replace_upstream_group_mapping = _Endpoint(
                settings={
                    'response_type': (UpstreamGroupMapping,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions/{issuer_id}/upstream_group_mapping/{upstream_group_mapping_id}',
                    'operation_id': 'replace_upstream_group_mapping',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'upstream_group_mapping_id',
                        'upstream_group_mapping',
                    ],
                    'required': [
                        'issuer_id',
                        'upstream_group_mapping_id',
                        'upstream_group_mapping',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'upstream_group_mapping_id':
                            (str,),
                        'upstream_group_mapping':
                            (UpstreamGroupMapping,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                        'upstream_group_mapping_id': 'upstream_group_mapping_id',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'upstream_group_mapping_id': 'path',
                        'upstream_group_mapping': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_upstream_group_mapping
            )

        def __reset_service_account(
            self,
            service_account_reset_body,
            **kwargs
        ):
            """Reset the service account for the specified issuer  # noqa: E501

            Reset the service account for the specified issuer  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.reset_service_account(service_account_reset_body, async_req=True)
            >>> result = thread.get()

            Args:
                service_account_reset_body (ServiceAccountResetBody): Service Account Reset Body

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Issuer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['service_account_reset_body'] = \
                service_account_reset_body
            return self.call_with_http_info(**kwargs)

        if self.reset_service_account is None:
            self.reset_service_account = _Endpoint(
                settings={
                    'response_type': (Issuer,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/reset_service_account',
                    'operation_id': 'reset_service_account',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'service_account_reset_body',
                    ],
                    'required': [
                        'service_account_reset_body',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'service_account_reset_body':
                            (ServiceAccountResetBody,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'service_account_reset_body': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__reset_service_account
            )

        def __reset_to_default_policy(
            self,
            issuer_id,
            reset_policy_request,
            **kwargs
        ):
            """Reset the current policy to the default policy  # noqa: E501

            Reset the current policy to the default policy. This will create a new policy as the active policy for your organisation. The old policy will still exist with the same policy_id but will be disassociated with this issuer.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.reset_to_default_policy(issuer_id, reset_policy_request, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path
                reset_policy_request (ResetPolicyRequest): Policy

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Policy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            kwargs['reset_policy_request'] = \
                reset_policy_request
            return self.call_with_http_info(**kwargs)

        if self.reset_to_default_policy is None:
            self.reset_to_default_policy = _Endpoint(
                settings={
                    'response_type': (Policy,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions/{issuer_id}/set_auth_policy_to_default',
                    'operation_id': 'reset_to_default_policy',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'reset_policy_request',
                    ],
                    'required': [
                        'issuer_id',
                        'reset_policy_request',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'reset_policy_request':
                            (ResetPolicyRequest,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'reset_policy_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__reset_to_default_policy
            )

        def __set_policy(
            self,
            issuer_id,
            policy_spec,
            **kwargs
        ):
            """Set the current policy to the policy sent  # noqa: E501

            Set the current policy to the given policy. This will replace the given issuer's policy with the content from the sent policy. Any ids will be used to link rules together, but be replaced, and any org_ids will be replaced with the org_id of the policy sent.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.set_policy(issuer_id, policy_spec, async_req=True)
            >>> result = thread.get()

            Args:
                issuer_id (str): issuer_id path
                policy_spec (PolicySpec): Policy

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Policy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['issuer_id'] = \
                issuer_id
            kwargs['policy_spec'] = \
                policy_spec
            return self.call_with_http_info(**kwargs)

        if self.set_policy is None:
            self.set_policy = _Endpoint(
                settings={
                    'response_type': (Policy,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/issuer_extensions/{issuer_id}/set_auth_policy',
                    'operation_id': 'set_policy',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'issuer_id',
                        'policy_spec',
                    ],
                    'required': [
                        'issuer_id',
                        'policy_spec',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'issuer_id':
                            (str,),
                        'policy_spec':
                            (PolicySpec,),
                    },
                    'attribute_map': {
                        'issuer_id': 'issuer_id',
                    },
                    'location_map': {
                        'issuer_id': 'path',
                        'policy_spec': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__set_policy
            )

        def __validate_upstream(
            self,
            org_id,
            **kwargs
        ):
            """Validate upstream issuer  # noqa: E501

            Validate upstream issuer  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.validate_upstream(org_id, async_req=True)
            >>> result = thread.get()

            Args:
                org_id (str): Organisation Unique identifier

            Keyword Args:
                issuer_upstream_url (str): upstream upstream url. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['org_id'] = \
                org_id
            return self.call_with_http_info(**kwargs)

        if self.validate_upstream is None:
            self.validate_upstream = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/issuers/validate_upstream',
                    'operation_id': 'validate_upstream',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'issuer_upstream_url',
                    ],
                    'required': [
                        'org_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'issuer_upstream_url':
                            (str,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'issuer_upstream_url': 'issuer_upstream_url',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'issuer_upstream_url': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__validate_upstream
            )

    create_client = None 
    create_issuer = None 
    create_policy = None 
    create_policy_rule = None 
    create_upstream_alias = None 
    create_upstream_group_mapping = None 
    delete_client = None 
    delete_policy = None 
    delete_policy_rule = None 
    delete_root = None 
    delete_upstream_alias = None 
    delete_upstream_group_mapping = None 
    get_client = None 
    get_issuer = None 
    get_policy = None 
    get_policy_rule = None 
    get_root = None 
    get_upstream_alias = None 
    get_upstream_group_mapping = None 
    get_upstreams = None 
    get_wellknown_issuer_info = None 
    list_clients = None 
    list_issuer_roots = None 
    list_issuer_upstreams = None 
    list_issuers = None 
    list_policies = None 
    list_policy_rules = None 
    list_upstream_aliases = None 
    list_upstream_group_mappings = None 
    list_wellknown_issuer_info = None 
    replace_client = None 
    replace_issuer = None 
    replace_policy = None 
    replace_policy_rule = None 
    replace_root = None 
    replace_upstream_alias = None 
    replace_upstream_group_mapping = None 
    reset_service_account = None 
    reset_to_default_policy = None 
    set_policy = None 
    validate_upstream = None 
