"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.10
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.list_policy_template_instances_response import ListPolicyTemplateInstancesResponse
from agilicus_api.model.object_type import ObjectType
from agilicus_api.model.policy_template_instance import PolicyTemplateInstance


class PolicyTemplatesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_policy_template_instance(
            self,
            policy_template_instance,
            **kwargs
        ):
            """Add a PolicyTemplateInstance  # noqa: E501

            Adds a new PolicyTemplateInstance. PolicyTemplates must have unique names within an org for a particular type of template. If the name is not unique, a 409 will be returned.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_policy_template_instance(policy_template_instance, async_req=True)
            >>> result = thread.get()

            Args:
                policy_template_instance (PolicyTemplateInstance):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PolicyTemplateInstance
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['policy_template_instance'] = \
                policy_template_instance
            return self.call_with_http_info(**kwargs)

        if self.create_policy_template_instance is None:
            self.create_policy_template_instance = _Endpoint(
                settings={
                    'response_type': (PolicyTemplateInstance,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/policy_template_instances',
                    'operation_id': 'create_policy_template_instance',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'policy_template_instance',
                    ],
                    'required': [
                        'policy_template_instance',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'policy_template_instance':
                            (PolicyTemplateInstance,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'policy_template_instance': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_policy_template_instance
            )

        def __delete_policy_template_instance(
            self,
            instance_id,
            **kwargs
        ):
            """Delete a PolicyTemplateInstance  # noqa: E501

            Delete a PolicyTemplateInstance  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_policy_template_instance(instance_id, async_req=True)
            >>> result = thread.get()

            Args:
                instance_id (str): The id of the instance to manipulate/get

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['instance_id'] = \
                instance_id
            return self.call_with_http_info(**kwargs)

        if self.delete_policy_template_instance is None:
            self.delete_policy_template_instance = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/policy_template_instances/{instance_id}',
                    'operation_id': 'delete_policy_template_instance',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'instance_id',
                        'org_id',
                    ],
                    'required': [
                        'instance_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'instance_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'instance_id': 'instance_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'instance_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_policy_template_instance
            )

        def __get_policy_template_instance(
            self,
            instance_id,
            **kwargs
        ):
            """Get a PolicyTemplateInstance  # noqa: E501

            Get a PolicyTemplateInstance  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_policy_template_instance(instance_id, async_req=True)
            >>> result = thread.get()

            Args:
                instance_id (str): The id of the instance to manipulate/get

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PolicyTemplateInstance
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['instance_id'] = \
                instance_id
            return self.call_with_http_info(**kwargs)

        if self.get_policy_template_instance is None:
            self.get_policy_template_instance = _Endpoint(
                settings={
                    'response_type': (PolicyTemplateInstance,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/policy_template_instances/{instance_id}',
                    'operation_id': 'get_policy_template_instance',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'instance_id',
                        'org_id',
                    ],
                    'required': [
                        'instance_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'instance_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'instance_id': 'instance_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'instance_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_policy_template_instance
            )

        def __list_policy_template_instances(
            self,
            **kwargs
        ):
            """List all standalone policy_templates  # noqa: E501

            List all PolicyTemplateInstances matching the provided query parameters.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_policy_template_instances(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                name (str): Filters based on whether or not the items in the collection have the given name. . [optional]
                include_invalid (bool): Includes invalid templates so that they may be cleaned up . [optional]
                template_type (str): filters based on the template type . [optional]
                template_types ([str]): filters based on a list of template types. . [optional]
                object_id (str): search by object id. [optional]
                object_type (ObjectType): An object type. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListPolicyTemplateInstancesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_policy_template_instances is None:
            self.list_policy_template_instances = _Endpoint(
                settings={
                    'response_type': (ListPolicyTemplateInstancesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/policy_template_instances',
                    'operation_id': 'list_policy_template_instances',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'name',
                        'include_invalid',
                        'template_type',
                        'template_types',
                        'object_id',
                        'object_type',
                        'org_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'name':
                            (str,),
                        'include_invalid':
                            (bool,),
                        'template_type':
                            (str,),
                        'template_types':
                            ([str],),
                        'object_id':
                            (str,),
                        'object_type':
                            (ObjectType,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'name': 'name',
                        'include_invalid': 'include_invalid',
                        'template_type': 'template_type',
                        'template_types': 'template_types',
                        'object_id': 'object_id',
                        'object_type': 'object_type',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'name': 'query',
                        'include_invalid': 'query',
                        'template_type': 'query',
                        'template_types': 'query',
                        'object_id': 'query',
                        'object_type': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                        'template_types': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_policy_template_instances
            )

        def __replace_policy_template_instance(
            self,
            instance_id,
            **kwargs
        ):
            """update a PolicyTemplateInstance  # noqa: E501

            update a PolicyTemplateInstance  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_policy_template_instance(instance_id, async_req=True)
            >>> result = thread.get()

            Args:
                instance_id (str): The id of the instance to manipulate/get

            Keyword Args:
                policy_template_instance (PolicyTemplateInstance): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PolicyTemplateInstance
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['instance_id'] = \
                instance_id
            return self.call_with_http_info(**kwargs)

        if self.replace_policy_template_instance is None:
            self.replace_policy_template_instance = _Endpoint(
                settings={
                    'response_type': (PolicyTemplateInstance,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/policy_template_instances/{instance_id}',
                    'operation_id': 'replace_policy_template_instance',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'instance_id',
                        'policy_template_instance',
                    ],
                    'required': [
                        'instance_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'instance_id':
                            (str,),
                        'policy_template_instance':
                            (PolicyTemplateInstance,),
                    },
                    'attribute_map': {
                        'instance_id': 'instance_id',
                    },
                    'location_map': {
                        'instance_id': 'path',
                        'policy_template_instance': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_policy_template_instance
            )

    create_policy_template_instance = None 
    delete_policy_template_instance = None 
    get_policy_template_instance = None 
    list_policy_template_instances = None 
    replace_policy_template_instance = None 
