"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.10
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from agilicus_api.exceptions import ApiAttributeError



class PolicyCondition(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('condition_type',): {
            'CLIENT_ID_LIST': "type_client_id_list",
            'ORG_ID_LIST': "type_org_id_list",
            'USER_ID_LIST': "type_user_id_list",
            'UPSTREAM_IDP_LIST': "type_upstream_idp_list",
            'IP_IN_CIDR_LIST': "type_ip_in_cidr_list",
            'LAST_SUCCESSFUL_MFA': "type_last_successful_mfa",
            'OBJECT_ATTRIBUTE': "type_object_attribute",
            'USER_HAS_ENROLLED_MULTIFACTOR_METHOD': "type_user_has_enrolled_multifactor_method",
        },
        ('operator',): {
            'EQUALS': "equals",
            'NOT_EQUALS': "not_equals",
            'GREATER_THAN': "greater_than",
            'LESS_THAN': "less_than",
            'IN': "in",
            'NOT_IN': "not_in",
        },
    }

    validations = {
        ('condition_type',): {
            'max_length': 100,
        },
        ('field',): {
            'max_length': 511,
            'regex': {
                'pattern': r'^([^\.]+\.?)*[^\.]+$',  # noqa: E501
            },
        },
    }

    @property
    def condition_type(self):
       return self.get("condition_type")

    @condition_type.setter
    def condition_type(self, new_value):
       self.condition_type = new_value

    @property
    def inverted(self):
       return self.get("inverted")

    @inverted.setter
    def inverted(self, new_value):
       self.inverted = new_value

    @property
    def input_is_list(self):
       return self.get("input_is_list")

    @input_is_list.setter
    def input_is_list(self, new_value):
       self.input_is_list = new_value

    @property
    def value(self):
       return self.get("value")

    @value.setter
    def value(self, new_value):
       self.value = new_value

    @property
    def operator(self):
       return self.get("operator")

    @operator.setter
    def operator(self, new_value):
       self.operator = new_value

    @property
    def field(self):
       return self.get("field")

    @field.setter
    def field(self, new_value):
       self.field = new_value

    @property
    def created(self):
       return self.get("created")

    @created.setter
    def created(self, new_value):
       self.created = new_value

    @property
    def updated(self):
       return self.get("updated")

    @updated.setter
    def updated(self, new_value):
       self.updated = new_value

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'condition_type': (str,),  # noqa: E501
            'value': (str,),  # noqa: E501
            'operator': (str,),  # noqa: E501
            'inverted': (bool,),  # noqa: E501
            'input_is_list': (bool,),  # noqa: E501
            'field': (str,),  # noqa: E501
            'created': (datetime,),  # noqa: E501
            'updated': (datetime,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'condition_type': 'condition_type',  # noqa: E501
        'value': 'value',  # noqa: E501
        'operator': 'operator',  # noqa: E501
        'inverted': 'inverted',  # noqa: E501
        'input_is_list': 'input_is_list',  # noqa: E501
        'field': 'field',  # noqa: E501
        'created': 'created',  # noqa: E501
        'updated': 'updated',  # noqa: E501
    }

    read_only_vars = {
        'created',  # noqa: E501
        'updated',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, condition_type, value, operator, *args, **kwargs):  # noqa: E501
        """PolicyCondition - a model defined in OpenAPI

        Args:
            condition_type (str): The type of this condition. The type determines how the value will be evaluated. This parameter is case sensitive.
            value (str): A JSON string representing the value to compare against. The structure of the comparision and type of the value depends on the condition type. A comparision is done to determine the result of the condition (either `true` or `false`)
            operator (str): The operator used to evaluate this condition. The operator field only applies when the condition type is type_object_attribute. The other types have implied operators.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            inverted (bool): This field is deprecated. Whether to invert the condition (ie the not operator). If the condition is `a == b` inverting the condition results in `not (a == b)`. [optional] if omitted the server will use the default value of False  # noqa: E501
            input_is_list (bool): Whether the input to the condition is in a list. The semantics of the condition when this flag is set is to compare every item in the list to the `value` using the `operator`. The condition is satisfied if any item in the list evaluates to true . [optional] if omitted the server will use the default value of False  # noqa: E501
            field (str): The object path to a field to use as input to the policy condition. This field only applies when the condition type is type_object_attribute. The supported objects are currently `users`, and `clients`. . [optional]  # noqa: E501
            created (datetime): Creation time. [optional]  # noqa: E501
            updated (datetime): Update time. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.condition_type = condition_type
        self.value = value
        self.operator = operator
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    def __python_set(val):
        return set(val)
 
    required_properties = __python_set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, condition_type, value, operator, *args, **kwargs):  # noqa: E501
        """PolicyCondition - a model defined in OpenAPI

        Args:
            condition_type (str): The type of this condition. The type determines how the value will be evaluated. This parameter is case sensitive.
            value (str): A JSON string representing the value to compare against. The structure of the comparision and type of the value depends on the condition type. A comparision is done to determine the result of the condition (either `true` or `false`)
            operator (str): The operator used to evaluate this condition. The operator field only applies when the condition type is type_object_attribute. The other types have implied operators.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            inverted (bool): This field is deprecated. Whether to invert the condition (ie the not operator). If the condition is `a == b` inverting the condition results in `not (a == b)`. [optional] if omitted the server will use the default value of False  # noqa: E501
            input_is_list (bool): Whether the input to the condition is in a list. The semantics of the condition when this flag is set is to compare every item in the list to the `value` using the `operator`. The condition is satisfied if any item in the list evaluates to true . [optional] if omitted the server will use the default value of False  # noqa: E501
            field (str): The object path to a field to use as input to the policy condition. This field only applies when the condition type is type_object_attribute. The supported objects are currently `users`, and `clients`. . [optional]  # noqa: E501
            created (datetime): Creation time. [optional]  # noqa: E501
            updated (datetime): Update time. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.condition_type = condition_type
        self.value = value
        self.operator = operator
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

