"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.10.10
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import unittest

import agilicus_api
from agilicus_api.api.labels_api import LabelsApi  # noqa: E501


class TestLabelsApi(unittest.TestCase):
    """LabelsApi unit test stubs"""

    def setUp(self):
        self.api = LabelsApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_bulk_delete_labelled_objects(self):
        """Test case for bulk_delete_labelled_objects

        Delete many label associations  # noqa: E501
        """
        pass

    def test_create_labelled_object(self):
        """Test case for create_labelled_object

        Add a labelled object  # noqa: E501
        """
        pass

    def test_create_labelled_object_label(self):
        """Test case for create_labelled_object_label

        Add a label association  # noqa: E501
        """
        pass

    def test_create_object_label(self):
        """Test case for create_object_label

        Add a label  # noqa: E501
        """
        pass

    def test_delete_labelled_object(self):
        """Test case for delete_labelled_object

        Delete a labelled object  # noqa: E501
        """
        pass

    def test_delete_labelled_object_label(self):
        """Test case for delete_labelled_object_label

        Delete a label association  # noqa: E501
        """
        pass

    def test_delete_object_label(self):
        """Test case for delete_object_label

        Delete a label  # noqa: E501
        """
        pass

    def test_get_labelled_object(self):
        """Test case for get_labelled_object

        Get a labelled object  # noqa: E501
        """
        pass

    def test_get_object_label(self):
        """Test case for get_object_label

        Get a label  # noqa: E501
        """
        pass

    def test_list_labelled_objects(self):
        """Test case for list_labelled_objects

        List all labelled objects  # noqa: E501
        """
        pass

    def test_list_object_labels(self):
        """Test case for list_object_labels

        List all labels  # noqa: E501
        """
        pass

    def test_replace_labelled_object(self):
        """Test case for replace_labelled_object

        update a labelled object  # noqa: E501
        """
        pass

    def test_replace_object_label(self):
        """Test case for replace_object_label

        update a label  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
