"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Env = exports.extractContainerPorts = exports.EnvFrom = exports.Cpu = exports.MountPropagation = exports.Container = exports.ImagePullPolicy = exports.EnvValue = exports.ResourceFieldPaths = exports.EnvFieldPaths = exports.ContainerSecurityContext = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const k8s = require("./imports/k8s");
const utils_1 = require("./utils");
/**
 * Container security attributes and settings.
 */
class ContainerSecurityContext {
    constructor(props = {}) {
        this.ensureNonRoot = props.ensureNonRoot ?? false;
        this.privileged = props.privileged ?? false;
        this.readOnlyRootFilesystem = props.readOnlyRootFilesystem ?? false;
        this.user = props.user;
        this.group = props.group;
    }
    /**
     * @internal
     */
    _toKube() {
        return {
            runAsGroup: this.group,
            runAsUser: this.user,
            runAsNonRoot: this.ensureNonRoot,
            privileged: this.privileged,
            readOnlyRootFilesystem: this.readOnlyRootFilesystem,
        };
    }
}
exports.ContainerSecurityContext = ContainerSecurityContext;
_a = JSII_RTTI_SYMBOL_1;
ContainerSecurityContext[_a] = { fqn: "cdk8s-plus-24.ContainerSecurityContext", version: "2.0.0-rc.96" };
var EnvFieldPaths;
(function (EnvFieldPaths) {
    /**
     * The name of the pod.
     */
    EnvFieldPaths["POD_NAME"] = "metadata.name";
    /**
     * The namespace of the pod.
     */
    EnvFieldPaths["POD_NAMESPACE"] = "metadata.namespace";
    /**
     * The uid of the pod.
     */
    EnvFieldPaths["POD_UID"] = "metadata.uid";
    /**
     * The labels of the pod.
     */
    EnvFieldPaths["POD_LABEL"] = "metadata.labels";
    /**
     * The annotations of the pod.
     */
    EnvFieldPaths["POD_ANNOTATION"] = "metadata.annotations";
    /**
     * The ipAddress of the pod.
     */
    EnvFieldPaths["POD_IP"] = "status.podIP";
    /**
     * The service account name of the pod.
     */
    EnvFieldPaths["SERVICE_ACCOUNT_NAME"] = "spec.serviceAccountName";
    /**
     * The name of the node.
     */
    EnvFieldPaths["NODE_NAME"] = "spec.nodeName";
    /**
     * The ipAddress of the node.
     */
    EnvFieldPaths["NODE_IP"] = "status.hostIP";
    /**
     * The ipAddresess of the pod.
     */
    EnvFieldPaths["POD_IPS"] = "status.podIPs";
})(EnvFieldPaths = exports.EnvFieldPaths || (exports.EnvFieldPaths = {}));
var ResourceFieldPaths;
(function (ResourceFieldPaths) {
    /**
     * CPU limit of the container.
     */
    ResourceFieldPaths["CPU_LIMIT"] = "limits.cpu";
    /**
     * Memory limit of the container.
     */
    ResourceFieldPaths["MEMORY_LIMIT"] = "limits.memory";
    /**
     * CPU request of the container.
     */
    ResourceFieldPaths["CPU_REQUEST"] = "requests.cpu";
    /**
     * Memory request of the container.
     */
    ResourceFieldPaths["MEMORY_REQUEST"] = "requests.memory";
    /**
     * Ephemeral storage limit of the container.
     */
    ResourceFieldPaths["STORAGE_LIMIT"] = "limits.ephemeral-storage";
    /**
     * Ephemeral storage request of the container.
     */
    ResourceFieldPaths["STORAGE_REQUEST"] = "requests.ephemeral-storage";
})(ResourceFieldPaths = exports.ResourceFieldPaths || (exports.ResourceFieldPaths = {}));
/**
 * Utility class for creating reading env values from various sources.
 */
class EnvValue {
    constructor(value, valueFrom) {
        this.value = value;
        this.valueFrom = valueFrom;
    }
    /**
     * Create a value by reading a specific key inside a config map.
     *
     * @param configMap - The config map.
     * @param key - The key to extract the value from.
     * @param options - Additional options.
     */
    static fromConfigMap(configMap, key, options = {}) {
        const source = {
            configMapKeyRef: {
                name: configMap.name,
                key,
                optional: options.optional,
            },
        };
        return new EnvValue(undefined, source);
    }
    /**
     * Defines an environment value from a secret JSON value.
     *
     * @param secretValue The secret value (secrent + key)
     * @param options Additional options
     */
    static fromSecretValue(secretValue, options = {}) {
        const source = {
            secretKeyRef: {
                name: secretValue.secret.name,
                key: secretValue.key,
                optional: options.optional,
            },
        };
        return new EnvValue(undefined, source);
    }
    /**
     * Create a value from the given argument.
     *
     * @param value - The value.
     */
    static fromValue(value) {
        return new EnvValue(value);
    }
    /**
     *
     * Create a value from a field reference.
     *
     * @param fieldPath: The field reference.
     * @param options: Additional options.
     */
    static fromFieldRef(fieldPath, options = {}) {
        let needsKey = false;
        if (fieldPath === EnvFieldPaths.POD_LABEL || fieldPath === EnvFieldPaths.POD_ANNOTATION) {
            needsKey = true;
        }
        if (needsKey && options.key === undefined) {
            throw new Error(`${fieldPath} requires a key`);
        }
        const source = {
            fieldRef: {
                fieldPath: (`${fieldPath}` + (needsKey ? `['${options.key}']` : '')),
                ...(options.apiVersion ? { apiVersion: options.apiVersion } : {}),
            },
        };
        return new EnvValue(undefined, source);
    }
    /**
     * Create a value from a resource.
     *
     * @param resource: Resource to select the value from.
     * @param options: Additional options.
     */
    static fromResource(resource, options = {}) {
        const source = {
            resourceFieldRef: {
                resource: `${resource}`,
                ...(options.divisor ? { divisor: k8s.IntOrString.fromString(options.divisor) } : {}),
                ...(options.container ? { containerName: options.container.name } : {}),
            },
        };
        return new EnvValue(undefined, source);
    }
    /**
     * Create a value from a key in the current process environment.
     *
     * @param key - The key to read.
     * @param options - Additional options.
     */
    static fromProcess(key, options = {}) {
        const value = process.env[key];
        if (options.required && !value) {
            throw new Error(`Missing ${key} env variable`);
        }
        return EnvValue.fromValue(value);
    }
}
exports.EnvValue = EnvValue;
_b = JSII_RTTI_SYMBOL_1;
EnvValue[_b] = { fqn: "cdk8s-plus-24.EnvValue", version: "2.0.0-rc.96" };
var ImagePullPolicy;
(function (ImagePullPolicy) {
    /**
     * Every time the kubelet launches a container, the kubelet queries the container image registry
     * to resolve the name to an image digest. If the kubelet has a container image with that exact
     * digest cached locally, the kubelet uses its cached image; otherwise, the kubelet downloads
     * (pulls) the image with the resolved digest, and uses that image to launch the container.
     *
     * Default is Always if ImagePullPolicy is omitted and either the image tag is :latest or
     * the image tag is omitted.
     */
    ImagePullPolicy["ALWAYS"] = "Always";
    /**
     * The image is pulled only if it is not already present locally.
     *
     * Default is IfNotPresent if ImagePullPolicy is omitted and the image tag is present but
     * not :latest
     */
    ImagePullPolicy["IF_NOT_PRESENT"] = "IfNotPresent";
    /**
     * The image is assumed to exist locally. No attempt is made to pull the image.
     */
    ImagePullPolicy["NEVER"] = "Never";
})(ImagePullPolicy = exports.ImagePullPolicy || (exports.ImagePullPolicy = {}));
/**
 * A single application container that you want to run within a pod.
 */
class Container {
    constructor(props) {
        if (props instanceof Container) {
            throw new Error('Attempted to construct a container from a Container object.');
        }
        this.name = props.name ?? 'main';
        this.image = props.image;
        this.port = props.port;
        this._command = props.command;
        this._args = props.args;
        this._readiness = props.readiness;
        this._liveness = props.liveness;
        this._startup = props.startup;
        this._lifecycle = props.lifecycle;
        this.resources = props.resources;
        this.workingDir = props.workingDir;
        this.mounts = props.volumeMounts ?? [];
        this.imagePullPolicy = props.imagePullPolicy ?? ImagePullPolicy.ALWAYS;
        this.securityContext = new ContainerSecurityContext(props.securityContext);
        this.env = new Env(props.envFrom ?? [], props.envVariables ?? {});
    }
    /**
     * Entrypoint array (the command to execute when the container starts).
     * @returns a copy of the entrypoint array, cannot be modified
     */
    get command() {
        return this._command ? [...this._command] : undefined;
    }
    /**
     * Arguments to the entrypoint.
     *
     * @returns a copy of the arguments array, cannot be modified.
     */
    get args() {
        return this._args ? [...this._args] : undefined;
    }
    /**
     * Mount a volume to a specific path so that it is accessible by the container.
     * Every pod that is configured to use this container will autmoatically have access to the volume.
     *
     * @param path - The desired path in the container.
     * @param storage - The storage to mount.
     */
    mount(path, storage, options = {}) {
        this.mounts.push({ path, volume: storage.asVolume(), ...options });
    }
    /**
     * @internal
     */
    _toKube() {
        const volumeMounts = [];
        for (const mount of this.mounts) {
            volumeMounts.push({
                name: mount.volume.name,
                mountPath: mount.path,
                readOnly: mount.readOnly,
                mountPropagation: mount.propagation,
                subPath: mount.subPath,
                subPathExpr: mount.subPathExpr,
            });
        }
        const ports = new Array();
        if (this.port) {
            ports.push({
                containerPort: this.port,
            });
        }
        // Resource requests and limits
        const cpuLimit = this.resources?.cpu?.limit?.amount;
        const cpuRequest = this.resources?.cpu?.request?.amount;
        const memoryLimit = this.resources?.memory?.limit;
        const memoryRequest = this.resources?.memory?.request;
        const ephemeralStorageLimit = this.resources?.ephemeralStorage?.limit;
        const ephemeralStorageRequest = this.resources?.ephemeralStorage?.request;
        const limits = {};
        const requests = {};
        if (cpuLimit) {
            limits.cpu = k8s.Quantity.fromString(cpuLimit);
        }
        if (memoryLimit) {
            limits.memory = k8s.Quantity.fromString(memoryLimit.toMebibytes().toString() + 'Mi');
        }
        if (ephemeralStorageLimit) {
            limits['ephemeral-storage'] = k8s.Quantity.fromString(ephemeralStorageLimit.toGibibytes().toString() + 'Gi');
        }
        if (cpuRequest) {
            requests.cpu = k8s.Quantity.fromString(cpuRequest);
        }
        if (memoryRequest) {
            requests.memory = k8s.Quantity.fromString(memoryRequest.toMebibytes().toString() + 'Mi');
        }
        if (ephemeralStorageRequest) {
            requests['ephemeral-storage'] = k8s.Quantity.fromString(ephemeralStorageRequest.toGibibytes().toString() + 'Gi');
        }
        let resourceRequirements = undefined;
        if (Object.keys(limits).length > 0 || Object.keys(requests).length > 0) {
            resourceRequirements = {
                limits: utils_1.undefinedIfEmpty(limits),
                requests: utils_1.undefinedIfEmpty(requests),
            };
        }
        const env = this.env._toKube();
        return {
            name: this.name,
            image: this.image,
            imagePullPolicy: this.imagePullPolicy,
            ports: utils_1.undefinedIfEmpty(ports),
            volumeMounts: utils_1.undefinedIfEmpty(volumeMounts),
            command: this.command,
            args: this.args,
            workingDir: this.workingDir,
            env: env.variables,
            envFrom: env.from,
            readinessProbe: this._readiness?._toKube(this),
            livenessProbe: this._liveness?._toKube(this),
            startupProbe: this._startup?._toKube(this),
            lifecycle: this._lifecycle ? {
                postStart: this._lifecycle.postStart?._toKube(this),
                preStop: this._lifecycle.preStop?._toKube(this),
            } : undefined,
            resources: resourceRequirements,
            securityContext: this.securityContext._toKube(),
        };
    }
}
exports.Container = Container;
_c = JSII_RTTI_SYMBOL_1;
Container[_c] = { fqn: "cdk8s-plus-24.Container", version: "2.0.0-rc.96" };
var MountPropagation;
(function (MountPropagation) {
    /**
     * This volume mount will not receive any subsequent mounts that are mounted
     * to this volume or any of its subdirectories by the host. In similar
     * fashion, no mounts created by the Container will be visible on the host.
     *
     * This is the default mode.
     *
     * This mode is equal to `private` mount propagation as described in the Linux
     * kernel documentation
     */
    MountPropagation["NONE"] = "None";
    /**
     * This volume mount will receive all subsequent mounts that are mounted to
     * this volume or any of its subdirectories.
     *
     * In other words, if the host mounts anything inside the volume mount, the
     * Container will see it mounted there.
     *
     * Similarly, if any Pod with Bidirectional mount propagation to the same
     * volume mounts anything there, the Container with HostToContainer mount
     * propagation will see it.
     *
     * This mode is equal to `rslave` mount propagation as described in the Linux
     * kernel documentation
     */
    MountPropagation["HOST_TO_CONTAINER"] = "HostToContainer";
    /**
     * This volume mount behaves the same the HostToContainer mount. In addition,
     * all volume mounts created by the Container will be propagated back to the
     * host and to all Containers of all Pods that use the same volume
     *
     * A typical use case for this mode is a Pod with a FlexVolume or CSI driver
     * or a Pod that needs to mount something on the host using a hostPath volume.
     *
     * This mode is equal to `rshared` mount propagation as described in the Linux
     * kernel documentation
     *
     * Caution: Bidirectional mount propagation can be dangerous. It can damage
     * the host operating system and therefore it is allowed only in privileged
     * Containers. Familiarity with Linux kernel behavior is strongly recommended.
     * In addition, any volume mounts created by Containers in Pods must be
     * destroyed (unmounted) by the Containers on termination.
     *
     */
    MountPropagation["BIDIRECTIONAL"] = "Bidirectional";
})(MountPropagation = exports.MountPropagation || (exports.MountPropagation = {}));
/**
 * Represents the amount of CPU.
 * The amount can be passed as millis or units.
 */
class Cpu {
    constructor(amount) {
        this.amount = amount;
    }
    static millis(amount) {
        return new Cpu(amount + 'm');
    }
    static units(amount) {
        return new Cpu(amount.toString());
    }
}
exports.Cpu = Cpu;
_d = JSII_RTTI_SYMBOL_1;
Cpu[_d] = { fqn: "cdk8s-plus-24.Cpu", version: "2.0.0-rc.96" };
/**
 * A collection of env variables defined in other resources.
 */
class EnvFrom {
    constructor(configMap, prefix, sec) {
        this.configMap = configMap;
        this.prefix = prefix;
        this.sec = sec;
    }
    ;
    /**
     * @internal
     */
    _toKube() {
        return {
            configMapRef: this.configMap ? {
                name: this.configMap.name,
            } : undefined,
            secretRef: this.sec ? {
                name: this.sec.name,
            } : undefined,
            prefix: this.prefix,
        };
    }
}
exports.EnvFrom = EnvFrom;
_e = JSII_RTTI_SYMBOL_1;
EnvFrom[_e] = { fqn: "cdk8s-plus-24.EnvFrom", version: "2.0.0-rc.96" };
function extractContainerPorts(selector) {
    if (!selector) {
        return [];
    }
    const ports = [];
    // we don't use instanceof intentionally since it can create
    // cyclic import problems.
    const containers = selector.containers;
    for (const con of containers ?? []) {
        if (con.port) {
            ports.push(con.port);
        }
    }
    return ports;
}
exports.extractContainerPorts = extractContainerPorts;
/**
 * Container environment variables.
 */
class Env {
    constructor(sources, variables) {
        this._sources = sources;
        this._variables = variables;
    }
    /**
     * Selects a ConfigMap to populate the environment variables with.
     * The contents of the target ConfigMap's Data field will represent
     * the key-value pairs as environment variables.
     */
    static fromConfigMap(configMap, prefix) {
        return new EnvFrom(configMap, prefix, undefined);
    }
    /**
     * Selects a Secret to populate the environment variables with.
     * The contents of the target Secret's Data field will represent
     * the key-value pairs as environment variables.
     */
    static fromSecret(secr) {
        return new EnvFrom(undefined, undefined, secr);
    }
    /**
     * Add a single variable by name and value.
     * The variable value can come from various dynamic sources such a secrets of config maps.
     * Use `EnvValue.fromXXX` to select sources.
     */
    addVariable(name, value) {
        this._variables[name] = value;
    }
    /**
     * The environment variables for this container.
     * Returns a copy. To add environment variables use `container.env.addVariable()`.
     */
    get variables() {
        return { ...this._variables };
    }
    /**
     * Add a collection of variables by copying from another source.
     * Use `Env.fromXXX` functions to select sources.
     */
    copyFrom(from) {
        this._sources.push(from);
    }
    /**
     * The list of sources used to populate the container environment,
     * in addition to the `variables`.
     *
     * Returns a copy. To add a source use `container.env.copyFrom()`.
     */
    get sources() {
        return [...this._sources];
    }
    renderEnv(env) {
        const result = new Array();
        for (const [name, v] of Object.entries(env)) {
            result.push({
                name,
                value: v.value,
                valueFrom: v.valueFrom,
            });
        }
        return result;
    }
    /**
     * @internal
     */
    _toKube() {
        return {
            from: utils_1.undefinedIfEmpty(this._sources.map(s => s._toKube())),
            variables: utils_1.undefinedIfEmpty(this.renderEnv(this._variables)),
        };
    }
}
exports.Env = Env;
_f = JSII_RTTI_SYMBOL_1;
Env[_f] = { fqn: "cdk8s-plus-24.Env", version: "2.0.0-rc.96" };
//# sourceMappingURL=data:application/json;base64,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