#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# @Author : 陈坤泽
# @Email  : 877362867@qq.com
# @Date   : 2023/12/29

"""
字符分类
"""

from collections import Counter
import math
import re

from pyxllib.prog.pupil import run_once, safe_div

# todo 加个 公式类型？
charclass_dict = {
    "标点": """－：、，；。！？“”（）【】""",
    "常用汉字": "一丁七万丈三上下不与丐丑专且世丘丙业丛东丝丢两严丧个中丰串临丸丹为主丽举乃久么义之乌乍乎乏乐乒乓乔乖乘乙九乞也习乡书买乱乳干了予争事二于亏云互五井亚些亡交亥亦产亩享京亭亮亲人亿什仁仅仆仇今介仍从仑仓仔他仗付仙代令以仪们仰仲件价任份仿企伊伍伏伐休众优伙会伞伟传伤伦伪伯估伴伶伸伺似佃但位低住佑体何余佛作你佣佩佳使侄侈例侍供依侠侣侥侦侧侨侮侯侵便促俄俊俏俐俗俘保信俩俭修俯俱俺倍倒倔倘候倚借倡倦债值倾假偎偏做停健偶偷偿傀傅傍储催傲傻像僚僧僵僻儒儡儿允元兄充兆先光克免兑兔党兜兢入全八公六兰共关兴兵其具典养兼兽冀内冈册再冒冕冗写军农冠冤冬冯冰冲决况冶冷冻净凄准凉凌减凑凛凝几凡凤凫凭凯凰凳凶凸凹出击函凿刀刁刃分切刊刑划列刘则刚创初删判刨利别刮到制刷券刹刺刻刽剂剃削前剑剔剖剥剧剩剪副割剿劈力劝办功加务劣动助努劫励劲劳势勃勇勉勋勒勘募勤勺勾勿匀包匆匈匕化北匙匠匣匪匹区医匾匿十千升午半华协卑卒卓单卖南博卜占卡卢卤卦卧卫印危即却卵卷卸卿厂厅历厉压厌厕厘厚原厢厦厨去县叁参又叉及友双反发叔取受变叙叛叠口古句另叨只叫召叭叮可台史右叶号司叹叼叽吁吃各吆合吉吊同名后吏吐向吓吕吗君吝吞吟吠否吧吨吩含听吭吮启吱吴吵吸吹吻吼呀呆呈告呐呕员呛呜呢周味呵呻呼命咆和咏咐咒咕咖咙咧咨咪咬咱咳咸咽哀品哄哆哈响哎哑哗哟哥哨哩哪哭哮哲哺哼唁唆唇唉唐唠唤唧唬售唯唱唾啃啄商啊啡啤啥啦啰啸啼喂善喇喉喊喘喜喝喧喳喷喻嗅嗓嗜嗡嗤嗦嗽嘀嘁嘉嘱嘲嘴嘶嘹嘿器噩噪嚎嚣嚷嚼囊囚四回因团囤园困囱围固国图圃圆圈土圣在地场圾址均坊坎坏坐坑块坚坛坝坞坟坠坡坤坦坪坯坷垂垃垄型垒垛垢垦垫垮埂埃埋城域埠培基堂堆堕堡堤堪堰堵塌塑塔塘塞填境墅墓墙增墨墩壁壕壤士壮声壳壶壹处备复夏夕外多夜够大天太夫夭央夯失头夷夸夹夺奄奇奈奉奋奏契奔奕奖套奠奢奥女奴奶奸她好如妄妆妇妈妒妓妖妙妥妨妹妻姆姊始姐姑姓委姚姜姥姨姻姿威娃娄娇娘娜娩娱娶婆婉婚婴婶婿媒媚媳嫁嫂嫉嫌嫡嫩嬉子孔孕字存孙孝孟季孤学孩孵孽宁它宅宇守安宋完宏宗官宙定宛宜宝实宠审客宣室宦宪宫宰害宴宵家容宽宾宿寂寄密寇富寒寓寝寞察寡寥寨寸对寺寻导寿封射将尉尊小少尔尖尘尚尝尤就尸尺尼尽尾尿局屁层居屈屉届屋屎屏屑展属屠屡履屯山屹屿岁岂岔岖岗岛岩岭岳岸峡峦峭峰峻崇崎崔崖崩崭嵌巍川州巡巢工左巧巨巩巫差己已巴巷巾币市布帅帆师希帐帕帖帘帚帜帝带席帮常帽幅幌幔幕幢平年并幸幻幼幽广庄庆庇床序庐库应底店庙府庞废度座庭庵庶康庸廉廊廓延廷建开异弃弄弊式弓引弛弟张弥弦弧弯弱弹强归当录形彤彩彪彬彭彰影役彻彼往征径待很徊律徐徒得徘徙御循微德徽心必忆忌忍志忘忙忠忧快忱念忽忿怀态怎怒怔怕怖怜思怠急性怨怪怯总恃恋恍恐恒恕恢恤恨恩恬恭息恰恳恶恼悄悉悍悔悟悠患悦您悬悯悲悴悼情惊惋惑惕惜惠惦惧惨惩惫惭惯惰想惶惹愁愈愉意愕愚感愤愧愿慈慌慎慕慢慧慨慰慷憋憎憔憨憾懂懈懊懒懦戈戏成我戒或战戚截戳戴户房所扁扇手才扎扑扒打扔托扛扣执扩扫扬扭扮扯扰扳扶批扼找承技抄把抑抒抓投抖抗折抚抛抠抡抢护报披抬抱抵抹押抽拂拄担拆拇拉拌拍拐拒拓拔拖拗拘拙招拜拟拢拣拥拦拧拨择括拭拯拱拳拴拷拼拾拿持挂指按挎挑挖挚挟挠挡挣挤挥挨挪挫振挺挽捂捅捆捉捌捍捎捏捐捕捞损捡换捣捧据捶捷捺捻掀掂授掉掌掏掐排掖掘掠探接控推掩措掰掷掸掺揉揍描提插揖握揣揩揪揭援揽搀搁搂搅搏搓搔搜搞搪搬搭携摄摆摇摊摔摘摧摩摸摹撇撑撒撕撞撤撩撬播撮撰撵撼擂擅操擎擒擦攀攒攘支收改攻放政故效敌敏救教敛敞敢散敦敬数敲整敷文斋斑斗料斜斟斤斥斧斩断斯新方施旁旅旋族旗无既日旦旧旨早旬旭旱时旷旺昂昆昌明昏易昔昙星映春昧昨昭是昵昼显晃晋晌晒晓晕晚晤晦晨普景晰晴晶智晾暂暇暑暖暗暮暴曙曲更曹曼曾替最月有朋服朗望朝期朦木未末本术朱朴朵机朽杀杂权杆杈杉李杏材村杖杜束杠条来杨杭杯杰松板极构枉析枕林枚果枝枢枣枪枫枯架枷柄柏某柑柒染柔柜柠查柬柱柳柴柿栅标栈栋栏树栓栖栗校株样核根格栽桂桃桅框案桌桐桑档桥桦桨桩桶梁梅梆梗梢梦梧梨梭梯械梳检棉棋棍棒棕棘棚棠森棱棵棺椅植椎椒椭椰椿楔楚楞楣楷楼概榄榆榔榕榛榜榨榴槐槽樊樟模横樱橄橘橙橡橱檀檐檩檬欠次欢欣欧欲欺款歇歉歌止正此步武歧歪歹死歼殃殉殊残殖殴段殷殿毁毅母每毒比毕毙毛毡毫毯氏民氓气氛氢氧氨氮氯水永汁求汇汉汗汛汞江池污汤汪汰汹汽沃沈沉沐沙沛沟没沥沦沧沪沫沮河沸油治沼沽沾沿泄泉泊泌法泛泞泡波泣泥注泪泰泳泵泻泼泽洁洋洒洗洛洞津洪洲活洼洽派流浅浆浇浊测济浑浓浙浦浩浪浮浴海浸涂消涉涌涎涕涛涝涡涣涤润涧涨涩涮涯液涵淀淆淋淌淑淘淡淤淫淮深淳混淹添清渊渐渔渗渠渡渣渤温港渴游渺湃湖湘湾湿溃溅溉源溜溢溪溯溶溺滋滑滓滔滚滞满滤滥滨滩滴漂漆漏漓演漠漩漫漱漾潘潜潦潭潮澄澈澎澜澡澳激濒瀑灌火灭灯灰灵灶灸灼灾灿炉炊炎炒炕炫炬炭炮炸点炼烁烂烈烘烙烛烟烤烦烧烫热烹焊焕焙焚焦焰然煌煎煞煤照煮熄熊熏熔熙熟熬燃燎燕燥爆爪爬爱爵父爷爸爹爽片版牌牍牙牛牡牢牧物牲牵特牺犀犁犬犯状犹狂狈狐狗狞狠狡独狭狮狰狱狸狼猎猖猛猜猩猪猫猬献猴猾猿玄率玉王玖玛玩玫环现玲玷玻珊珍珠班球琅理琉琐琢琳琴琼瑞瑟瑰璃璧瓜瓢瓣瓤瓦瓮瓶瓷甘甚甜生甥用甩甫田由甲申电男甸画畅界畏畔留畜略畦番畴畸疆疏疑疗疙疚疟疤疫疮疯疲疹疼疾病症痊痒痕痘痛痢痪痰痴痹瘟瘤瘦瘩瘪瘫瘸瘾癌癞癣登白百皂的皆皇皮皱皿盅盆盈益盏盐监盒盔盖盗盘盛盟目盯盲直相盹盼盾省眉看真眠眨眯眶眷眼着睁睛睡督睦睬睹瞄瞎瞒瞧瞪瞬瞳瞻矗矛矢知矩矫短矮石矾矿码砂砌砍研砖砚砰破砸砾础硅硕硝硫硬确硼碉碌碍碎碑碗碘碟碧碰碱碳碴碾磁磅磕磨磷磺礁示礼社祈祖祝神祟祠祥票祭祷祸禀禁福离禽禾秀私秃秆秉秋种科秒秕秘租秤秦秧秩秫积称秸移秽稀程稍税稚稠稳稻稼稽稿穆穗穴究穷空穿突窃窄窍窑窒窖窗窘窜窝窟窥窿立竖站竞竟章竣童竭端竹竿笆笋笑笔笙笛笤符笨第笼等筋筏筐筑筒答策筛筝筷筹签简箍箕算管箩箫箭箱篇篓篙篡篮篱篷簇簸簿籍米类籽粉粒粗粘粟粤粥粪粮粱粹精糊糕糖糙糜糟糠糯系紊素索紧紫累絮繁纠红纤约级纪纫纬纯纱纲纳纵纷纸纹纺纽线练组绅细织终绊绍绎经绑绒结绕绘给络绝绞统绢绣继绩绪续绰绳维绵绷绸综绽绿缀缅缆缎缓缔缕编缘缚缝缠缤缨缩缭缰缴缸缺罐网罕罗罚罢罩罪置署羊美羔羞羡群羹羽翁翅翎翔翘翠翩翰翻翼耀老考者而耍耐耕耗耘耙耳耸耻耽耿聂聊聋职联聘聚聪肃肄肆肉肋肌肖肘肚肛肝肠股肢肤肥肩肪肮肯育肴肺肾肿胀胁胃胆背胎胖胚胜胞胡胧胯胰胳胶胸能脂脆脉脊脏脐脑脓脖脚脯脱脸脾腊腋腌腐腔腕腥腮腰腹腺腻腾腿膀膊膏膘膛膜膝膨膳臀臂臊臣自臭至致臼舀舅舆舌舍舒舔舞舟航般舰舱舵舶舷船艇艘良艰色艳艺艾节芋芍芒芙芜芝芥芦芬芭芯花芳芹芽苇苍苏苔苗苛苞苟若苦苫英苹茁茂范茄茅茉茎茧茫茬茴茵茶茸荆草荐荒荔荚荞荠荡荣荤荧药荷荸莉莫莱莲获莹莺莽菇菊菌菜菠菩菱菲萄萌萍萎萝萤营萧萨落著葛葡董葫葬葱葵蒂蒋蒙蒜蒲蒸蒿蓄蓉蓖蓝蓬蔑蔓蔗蔚蔫蔬蔼蔽蕉蕊蕴蕾薄薇薛薪薯藏藐藕藤藻蘑蘸虎虏虐虑虚虫虱虹虽虾蚀蚁蚂蚊蚌蚓蚕蚜蚣蚤蚪蚯蛀蛆蛇蛉蛋蛔蛙蛛蛤蛮蛹蛾蜀蜂蜈蜒蜓蜕蜗蜘蜜蜡蜻蝇蝉蝌蝎蝗蝙蝠蝴蝶螃融螟螺蟀蟆蟋蟹蠕蠢血衅行衍衔街衙衡衣补表衩衫衬衰衷袁袄袋袍袒袖袜被袭袱裁裂装裆裕裙裤裳裸裹褂褐褒褥褪襟西要覆见观规觅视览觉角解触言誉誊誓警譬计订认讥讨让训议讯记讲讳讶许讹论讼讽设访诀证评诅识诈诉诊词译试诗诚话诞诡询该详诫诬语误诱诲说诵请诸诺读诽课谁调谅谆谈谊谋谍谎谐谒谓谚谜谢谣谤谦谨谬谭谱谴谷豁豆豌象豪豫豹豺貌贝贞负贡财责贤败账货质贩贪贫贬购贮贯贰贱贴贵贷贸费贺贼贾贿赁赂赃资赊赋赌赎赏赐赔赖赘赚赛赞赠赡赢赤赦赫走赴赵赶起趁超越趋趟趣足趴趾跃跋跌跑跛距跟跨跪路跳践跷跺踊踏踢踩踪踱蹂蹄蹈蹋蹦蹬蹭蹲躁躏身躬躯躲躺车轧轨轩转轮软轰轴轻载轿较辅辆辈辉辐辑输辕辖辙辛辜辞辟辣辨辩辫辰辱边辽达迁迂迄迅过迈迎运近返还这进远违连迟迫述迷迹追退送适逃逆选逊透逐递途逗通逛逝逞速造逢逮逸逻逼逾遂遇遍遏道遗遣遥遭遮遵避邀邑邓邢那邦邪邮邻郁郊郎郑部郭都鄙酌配酒酗酝酣酥酪酬酱酵酷酸酿醇醉醋醒采释里重野量金鉴针钉钓钙钝钞钟钠钢钥钦钧钩钮钱钳钻钾铁铃铅铆铐铛铜铝铡铣铭铲银铸铺链销锁锄锅锈锉锋锌锐错锚锡锣锤锥锦锨锭键锯锰锹锻镀镇镊镐镜镣镰镶长门闪闭问闯闰闲间闷闸闹闺闻闽阀阁阅阎阐阔队阱防阳阴阵阶阻阿附际陆陈陋陌降限陕陡院除陨险陪陵陶陷隅隆随隐隔隘隙障隧隶难雀雁雄雅集雇雌雏雕雨雪雳零雷雹雾需震霉霍霎霜霞露霸霹青靖静非靠靡面革靴靶鞋鞍鞠鞭韧韩韭音韵页顶顷项顺须顽顾顿颁颂预颅领颇颈颊频颓颖颗题颜额颠颤风飒飘飞食餐饥饭饮饰饱饲饵饶饺饼饿馁馅馆馋馍馏馒首香马驮驯驰驱驳驴驶驹驻驼驾骂骄骆骇验骏骑骗骚骡骤骨髓高鬓鬼魁魂魄魏魔鱼鲁鲜鲤鲫鲸鳄鳍鳖鳞鸟鸠鸡鸣鸥鸦鸭鸯鸳鸵鸽鸿鹃鹅鹉鹊鹏鹤鹦鹰鹿麦麸麻黄黍黎黑黔默鼎鼓鼠鼻齐齿龄龙龟",
    "繁体汉字": "丟丣並乗乹乾亁亂亙亝亞亱亷亾佇佈佔併來侖侶侷俁係俓俔俠俥俬俻倀倆倈倉個倐們倖倣倫倲倸偉偑側偵偽傌傑傖傘備傚傢傭傯傳傴債傷傾僂僅僉僊働僑僕僞僤僥僨僱價儀儁儂億儈儉儌儎儐儔儕儘償儣優儭儲儷儸儺儻儼兇兌兎兒兗兠內兩冄冊冐冑冪冺凈凍凙凜凢凱凴別刦刧刪刼剄則剉剋剎剏剗剙剛剝剮剳剴創剷剹剾劃劄劇劉劊劌劍劏劑劒劚効勁勅勌勑動務勛勝勞勢勣勦勩勱勳勵勸勻匟匭匯匱匲匳區協卹卻卽厀厙厠厤厭厰厲厴參叄叢吒吚吳吶呂呌呪咊咼員哯哶唄唓唕唘唚唸啎問啑啓啗啞啟啢啣喎喚喪喫喬單喲嗁嗆嗇嗊嗎嗚嗩嗰嗶嗹嘆嘍嘑嘓嘔嘖嘗嘜嘠嘩嘪嘮嘯嘰嘳嘵嘷嘸嘺嘽噁噅噉噓噚噝噞噠噥噦噯噲噴噸噹嚀嚇嚌嚐嚕嚙嚛嚥嚦嚧嚨嚮嚲嚳嚴嚶嚽囀囁囂囃囅囈囉囌囑囒囓囙囪圅圇國圍園圓圖團圞坿垜垻埡埨埬埰執堅堊堖堚堝堯報場塊塋塏塒塗塚塟塢塤塲塵塸塹塿墊墖墜墠墮墰墲墳墶墻墾壇壈壋壎壓壗壘壙壚壜壞壟壠壢壣壩壪壯壺壻壼壽夘夠夢夥夾奐奧奩奪奬奮奼妝妬妳妷姉姍姙姦姪姸娙娛婁婡婣婦婬婭媈媍媧媯媰媼媽媿嫋嫗嫰嫵嫺嫻嫿嬀嬃嬇嬈嬋嬌嬙嬝嬡嬣嬤嬦嬪嬭嬰嬸嬻嬾孃孄孆孇孋孌孎孫學孻孼孾孿宂宮寀寃寑寠寢實寧審寫寬寳寵寶尅將專尋對導尒尙尟尠尷屆屍屓屛屜屢層屨屩屬屭岅岡峝峯峴島峽崍崑崗崙崢崬嵐嵗嵼嵽嵾嶁嶃嶄嶇嶈嶔嶗嶘嶠嶢嶧嶨嶮嶸嶹嶺嶼嶽巊巋巒巔巖巗巘巠巰巵巹帀帋帥師帬帳帶幀幃幇幑幓幗幘幙幚幝幟幣幩幫幬幹幾庫庻庽廁廂廄廈廎廐廕廚廝廞廟廠廡廢廣廧廩廬廳廵廹廻弒弔弳張強彃彄彆彈彌彎彔彙彞彠彥彫彲彿徃後徑從徠徧復徵徹徿怱怳恆恠恡恥悅悞悤悵悶悽惏惡惥惱惲惷惻愛愜愨愴愷愻愽愾慄態慍慘慙慚慟慣慤慪慫慮慳慴慶慺慼慽慾憂憇憊憍憐憑憒憖憚憢憤憫憮憲憶憸憹懀懇應懌懍懎懞懟懣懤懧懨懲懶懷懸懺懼懾戀戇戔戞戧戩戰戱戲戶戹扞抝拋拚挩挱挵挾捄捨捫捱捲掃掄掆掗掙掚掛採掽揀揑揚換揫揮揯揷揹搆搇搉損搖搗搤搥搨搯搵搶搾摃摋摐摑摜摟摯摳摶摺摻撈撊撏撐撓撝撟撡撣撥撦撧撫撲撳撻撾撿擁擄擇擊擋擓擔擕據擟擠擣擥擧擫擬擯擰擱擲擴擷擺擻擼擽擾攄攆攋攏攔攖攙攛攜攝攢攣攤攩攪攬攷敂敍敎敓敗敘敵數敺斂斃斅斆斕斬斷斸於旂旣旤旹旾昇昬時晉晛晝暈暉暐暘暢暫暱曄曆曇曉曊曏曖曠曡曥曨曬書會朞朢朥朧朮朶東杴枱枴柵柺査栁栞栢栰桒桮桱桺桿梔梖梘梜條梟梲棄棊棖棗棟棡棧棲棶椏椗椲椶椷椾楇楊楓楥楨業極榘榦榪榮榲榿構槍槓槕槤槧槨槫槮槳槶槼樁樂樅樑樓標樞樠樢樣樤樧樫樳樸樹樺樿橈橋橜機橢橫橯檁檉檔檜檟檢檣檭檮檯檳檵檸檻櫃櫅櫈櫍櫓櫚櫛櫝櫞櫟櫠櫥櫧櫨櫪櫫櫬櫱櫳櫸櫻欄欅欇權欍欏欐欑欒欓欖欘欝欞欵欽歎歐歛歟歡歲歴歷歸歿殀殘殞殢殤殨殫殭殮殯殰殲殺殻殼毀毆毊毧毬毿氂氈氊氌氣氫氬氭氳氷氾汎汙汚決沒沖況泝洩洶浹浿涇涖涗涼淒淚淛淥淨淩淪淵淶淺渖渙減渢渦測渾湊湋湞湧湯湼溈準溝溡溫溮溳溼滄滅滌滎滙滛滬滯滲滷滸滻滾滿漁漊漍漚漢漣漬漲漵漸漿潁潄潑潔潕潙潚潛潣潤潯潰潷潿澀澁澅澆澇澐澗澠澤澦澩澫澬澮澱澾濁濃濄濆濇濕濘濚濛濜濟濤濧濫濰濱濶濺濼濾濿瀂瀃瀅瀆瀇瀉瀋瀏瀕瀘瀝瀟瀠瀦瀧瀨瀰瀲瀾灃灄灋灍灑灒灕灘灙灝灠灡灣灤灧灩災為烏烖烴無煇煉煑煒煗煙煢煥煩煬煱熂熅熈熉熌熒熓熗熚熡熰熱熲熾燀燁燄燈燉燒燖燙燜營燦燬燭燴燶燻燼燾爃爄爇爍爐爖爗爛爥爧爭爲爺爾牀牆牋牎牐牓牕牘牠牴牽犖犛犞犢犧狀狥狹狽猂猌猙猨猶猻獁獃獄獅獊獎獘獧獨獩獪獫獮獰獱獲獵獷獸獺獻獼玀玁玅珼現琖琱琺琿瑇瑋瑒瑣瑤瑩瑪瑯瑲瑻瑽璉璊璕璗璝璡璢璣璦璫璯環璵璸璼璽璾璿瓄瓅瓊瓏瓔瓕瓚瓛甌" + "賠議結訴關確該總額義訟計與請舊經辦處萬統絕進達負責駁發間項魯閣繪連絡電話說複認細",
    "偏僻汉字": "丂丄丅丆丌丏丒丕丗丞丠両丨丩丫丬丮丯丱丳丵丶丷丼丿乀乁乂乄乆乇乊乑乕乚乛乜乢乣乤乥乧乨乩乪乫乬乭乮乯乲乴乵乶乷乸乺乻乼乽乿亀亃亄亅亇亊亍亐亓亖亗亘亜亟亠亢亣亨亪亯亰亳亴亵亶亸亹亻亼亽仂仃仄仈仉仌仏仐仒仕仚仛仜仝仞仟仠仡仢仦仧仨仩仫仭仮仯仱仳仴仵仸仹仺仼仾伀伂伃伄伅伆伇伈伉伋伌伎伒伓伔伕伖伛伜伝伡伢伣伥伧伨伩伫伬伭伮伱伲伳伵伷伹伻伽伾伿佀佁佂佄佅佉佊佋佌佐佒佖佗佘佚佝佞佟佡佢佤佥佦佧佨佪佫佬佭佮佯佰佱佲佴佶佷佸佹佺佻佼佽佾侀侁侂侃侅侇侉侊侌侎侏侐侑侒侓侔侕侗侘侙侚侜侞侟価侢侤侩侪侫侬侭侰侱侲侳侴侸侹侺侻侼侽侾俀俅俆俇俈俉俋俌俍俎俑俒俕俖俙俚俛俜俞俟俢俣俤俦俧俨俪俫俰俲俳俴俵俶俷俸俹俼俽俾俿倁倂倃倄倅倇倊倌倎倏倓倕倗倛倜倝倞倠倢値倥倧倨倩倪倬倭倮倯倰倱倳倴倵倶倷倹倻倽倿偀偁偂偃偄偅偆偈偊偋偌偍偐偒偓偔偕偖偗偘偙偛偝偞偟偠偡偢偣偤偦偧偨偩偪偫偬偭偮偯偰偱偲偳偸偹偺偻偼偾傁傂傃傄傆傇傈傉傊傋傎傏傐傒傓傔傕傗傛傜傝傞傟傠傡傣傤傥傦傧傩傪傫傮傰傱傶傸傹傺傼傽傿僀僁僃僄僆僇僈僋僌僎僐僒僓僔僖僗僘僙僛僜僝僟僠僡僢僣僦僩僪僫僬僭僮僯僰僲僳僴僶僷僸僺僼僽僾僿儃儅儆儇儊儋儍儏儑儓儖儗儙儚儛儜儝儞儠儢儤儥儦儧儨儩儫儬儮儯儰儱儳儴儵儶儹儽儾兀兂兊兏児兓兕兖兘兙兛兝兞兟兡兣兤兦兪兮兯兲兹兺兾兿冁冂冃円冇冉冋冎冏冓冔冖冘冚冝冞冟冡冢冣冥冦冧冨冩冫冭冮冱冴冸冹冼冽冾冿凁凂凃凅凇凊凋凎凐凒凓凔凕凖凗凘凚凞凟凣凥処凧凨凩凪凬凮凲凵凷凼凾刂刄刅刈刉刋刌刍刎刏刐刓刔刕刖刜刞刟刡刢刣刬刭刯刱刲刳刴刵刾刿剀剁剅剆剈剌剐剒剓剕剘剚剜剞剟剠剡剢剣剤剦剨剫剬剭剰剱剶剸剺剻剼剽劀劁劂劅劆劋劎劐劓劔劕劖劗劘劙劜劢劤劥劦劧劬劭劮劯劰労劵劶劷劸劺劻劼劽劾勀勂勄勆勈勊勍勎勏勐勓勔勖勗勚勜勠勡勥勧勨勪勫勬勭勮勯勰勲勴勶勷勹勼勽匁匂匃匄匇匉匊匋匌匍匎匏匐匑匒匓匔匘匚匛匜匝匞匡匢匤匥匦匧匨匩匫匬匮匰匴匵匶匷匸匼匽卂卄卅卆卉卋卌卍卐単卙卛卝卞卟卣卥卨卩卪卬卭卮卯卲卶卺卼卾厁厃厄厇厈厊厍厎厏厐厑厒厓厔厖厗厛厜厝厞厡厣厥厧厩厪厫厬厮厯厱厳厵厶厷厸厹厺厼厽厾叀叅叆叇収叏叐叒叓叕叚叜叝叞叟叡叧叩叱叴叵叺叻叾叿吀吂吅吇吋吔吖吘吙吜吡吢吣吤吥吪吰吲吷吺吽吾吿呁呃呄呅呇呉呋呍呎呏呑呒呓呔呖呗呙呚呝呞呟呠呡呣呤呥呦呧呩呫呬呭呮呯呰呱呲呴呶呷呸呹呺呾呿咀咁咂咃咄咅咇咈咉咋咍咎咑咓咔咗咘咚咛咜咝咞咟咠咡咢咣咤咥咦咩咫咭咮咯咰咲咴咵咶咷咹咺咻咾咿哂哃哅哇哉哊哋哌哏哐哒哓哔哕哖哘哙哚哛哜哝哞哠哢哣哤哦哧哫哬哰哱哳哴哵哷哸哹哻哽哾哿唀唂唃唅唈唊唋唌唍唎唏唑唒唔唖唗唙唛唜唝唞唟唡唢唣唥唦唨唩唪唫唭唰唲唳唴唵唶唷唹唺唻唼唽唿啀啁啂啅啇啈啉啋啌啍啐啒啔啕啖啘啙啚啛啜啝啠啧啨啩啪啫啬啭啮啯啱啲啳啴啵啶啷啹啺啻啽啾啿喀喁喃喅喆喈喋喌喍喏喐喑喒喓喔喕喖喗喙喛喞喟喠喡喢喣喤喥喦喨喩喭喯喰喱喴喵営喸喹喺喼喽喾喿嗀嗂嗃嗄嗈嗉嗋嗌嗍嗏嗐嗑嗒嗔嗕嗖嗗嗘嗙嗛嗝嗞嗟嗠嗢嗣嗥嗧嗨嗪嗫嗬嗭嗮嗯嗱嗲嗳嗴嗵嗷嗸嗺嗻嗼嗾嗿嘂嘃嘄嘅嘇嘈嘊嘋嘌嘎嘏嘐嘒嘕嘘嘙嘚嘛嘝嘞嘟嘡嘢嘣嘤嘥嘦嘧嘨嘫嘬嘭嘻嘼嘾噀噂噃噄噆噇噈噊噋噌噍噎噏噐噑噒噔噕噖噗噘噙噛噜噟噡噢噣噤噧噫噬噭噮噰噱噳噵噶噷噺噻噼噽噾噿嚁嚂嚃嚄嚅嚆嚈嚉嚊嚋嚍嚏嚑嚒嚓嚔嚖嚗嚘嚚嚜嚝嚞嚟嚠嚡嚢嚤嚩嚪嚫嚬嚭嚯嚰嚱嚵嚸嚹嚺嚻嚾嚿囄囆囇囋囍囎囏囐囔囕囖囗囘囜囝囟囡団囥囦囧囨囩囫囬囮囯囲図囵囶囷囸囹囻囼囿圀圁圂圄圉圊圌圎圏圐圑圔圕圗圙圚圛圜圝圠圡圢圤圥圦圧圩圪圫圬圭圮圯圱圲圳圴圵圶圷圸圹圻圼圽圿坁坂坃坄坅坆坈坉坋坌坍坒坓坔坕坖坘坙坜坢坣坥坧坨坩坫坬坭坮坰坱坲坳坴坵坶坸坹坺坻坼坽坾垀垁垅垆垇垈垉垊垌垍垎垏垐垑垓垔垕垖垗垘垙垚垝垞垟垠垡垣垤垥垧垨垩垪垬垭垯垰垱垲垳垴垵垶垷垸垹垺垼垽垾垿埀埁埄埅埆埇埈埉埊埌埍埏埐埑埒埓埔埕埖埗埘埙埚埛埜埝埞埢埣埤埥埦埧埩埪埫埭埮埯埱埲埳埴埵埶埸埻埼埽埾埿堀堁堃堄堇堈堉堋堌堍堎堏堐堑堒堓堔堗堘堙堛堜堞堟堠堢堣堥堦堧堨堩堫堬堭堮堲堳堶堷堸堹堺堻堼堽堾堿塀塁塂塃塄塅塆塇塈塉塍塎塐塓塕塖塙塛塜塝塠塡塣塥塦塧塨塩塪塬塭塮塯塰塱塳塴塶塷塺塻塼塽塾墀墁墂墄墆墇墈墉墋墌墍墎墏墐墑墒墔墕増墘墚墛墝墟墡墢墣墤墥墦墧墪墫墬墭墯墱墴墵墷墸墹墺墼墽墿壀壂壃壄壅壆壉壊壌壍壏壐壑壒壔壖壛壝壡壥壦壧壨壬壭壱売壴壵壷壸壾壿夀夁夂夃夅夆夈変夊夋夌夎夐夑夒夓夔夗夙夛夝夞夡夣夤夦夨夬夰夲夳夵夶夻夼夽夿奀奁奂奃奅奆奊奌奍奎奒奓奘奙奚奛奜奝奞奟奡奣奤奦奨奫奭奯奰奱奲奵奷奺奻奾奿妀妁妃妅妉妊妋妌妍妎妏妐妑妔妕妗妘妚妛妜妞妟妠妡妢妣妤妦妧妩妪妫妭妮妯妰妱妲妴妵妶妸妺妼妽妾妿姀姁姂姃姄姅姇姈姌姎姏姒姕姖姗姘姛姝姞姟姠姡姢姣姤姧姩姫姬姭姮姯姰姱姲姳姴姵姶姷姹姺姼姽姾娀娂娅娆娈娉娊娋娌娍娎娏娐娑娒娓娔娕娖娗娚娝娞娟娠娡娢娣娤娥娦娧娨娪娫娬娭娮娯娰娲娳娴娵娷娸娹娺娻娼娽娾娿婀婂婃婄婅婇婈婊婋婌婍婎婏婐婑婒婓婔婕婖婗婘婙婛婜婝婞婟婠婢婤婥婧婨婩婪婫婮婯婰婱婲婳婵婷婸婹婺婻婼婽婾媀媁媂媃媄媅媆媇媉媊媋媌媎媏媐媑媓媔媕媖媗媘媙媛媜媝媞媟媠媡媢媣媤媥媦媨媩媪媫媬媭媮媱媲媴媵媶媷媸媹媺媻媾嫀嫃嫄嫅嫆嫇嫈嫊嫍嫎嫏嫐嫑嫒嫓嫔嫕嫖嫘嫙嫚嫛嫜嫝嫞嫟嫠嫢嫣嫤嫥嫦嫧嫨嫪嫫嫬嫭嫮嫯嫱嫲嫳嫴嫶嫷嫸嫹嫼嫽嫾嬁嬂嬄嬅嬆嬊嬍嬎嬏嬐嬑嬒嬓嬔嬕嬖嬗嬘嬚嬛嬜嬞嬟嬠嬢嬥嬧嬨嬩嬫嬬嬮嬯嬱嬲嬳嬴嬵嬶嬷嬹嬺嬼嬽嬿孀孁孂孅孈孉孊孍孏孑孒孓孖孚孛孜孞孠孡孢孥孧孨孪孬孭孮孯孰孱孲孳孴孶孷孹孺宀宄宆宊宍宎宐宑宒宓宔宕宖実宥宧宨宩宬宭宯宱宲宷宸宺宻宼寁寅寈寉寊寋寍寎寏寐寔寕寖寗寘寙寚寛寜寣寤寪寭寮寯寰寱寲寴寷寽対尀専尃尌尐尓尕尗尛尜尞尡尢尣尥尦尧尨尩尪尫尬尭尮尯尰尲尳尴尵尶尹尻屃屄屇屌屐屒屔屖屗屘屙屚屝屟屣屦屧屪屫屮屰屲屳屴屵屶屷屸屺屻屼屽屾岀岃岄岆岇岈岉岊岋岌岍岎岏岐岑岒岓岕岘岙岚岜岝岞岟岠岢岣岤岥岦岧岨岪岫岬岮岯岰岱岲岴岵岶岷岹岺岻岼岽岾岿峀峁峂峃峄峅峆峇峈峉峊峋峌峍峎峏峐峑峒峓峔峕峖峗峘峙峚峛峜峞峟峠峢峣峤峥峧峨峩峪峫峬峮峱峲峳峵峷峸峹峺峼峾峿崀崁崂崃崄崅崆崈崉崊崋崌崏崐崒崓崕崘崚崛崜崝崞崟崠崡崣崤崥崦崧崨崪崫崮崯崰崱崲崳崴崵崶崷崸崹崺崻崼崽崾崿嵀嵁嵂嵃嵄嵅嵆嵇嵈嵉嵊嵋嵍嵎嵏嵑嵒嵓嵔嵕嵖嵘嵙嵚嵛嵜嵝嵞嵟嵠嵡嵢嵣嵤嵥嵦嵧嵨嵩嵪嵫嵬嵭嵮嵯嵰嵱嵲嵳嵴嵵嵶嵷嵸嵹嵺嵻嵿嶀嶂嶅嶆嶉嶊嶋嶌嶍嶎嶏嶐嶑嶒嶓嶕嶖嶙嶚嶛嶜嶝嶞嶟嶡嶣嶤嶥嶦嶩嶪嶫嶬嶭嶯嶰嶱嶲嶳嶴嶵嶶嶷嶻嶾嶿巀巁巂巃巄巅巆巇巈巉巌巎巏巐巑巓巕巙巚巛巜巟巣巤巪巬巭巯巳巶巸巺巻巼巽巿帄帇帉帊帍帎帏帑帒帓帔帗帙帛帞帟帠帡帢帣帤帧帨帩帪帯帰帱帲帴帵帷帹帺帻帼帾帿幁幂幄幆幈幉幊幋幍幎幏幐幒幖幛幜幞幠幡幤幥幦幧幨幪幭幮幯幰幱幵幷幺庀庁庂広庅庈庉庋庌庍庎庑庒庖庘庚庛庝庠庡庢庣庤庥庨庩庪庬庮庯庰庱庲庳庴庹庺庼庾庿廀廃廅廆廇廋廌廍廏廑廒廔廖廗廘廙廛廜廤廥廦廨廪廫廭廮廯廰廱廲廴廸廼廽廾廿弁弅弆弇弈弉弋弌弍弎弐弑弖弗弘弙弚弜弝弞弡弢弣弤弨弩弪弫弬弭弮弰弲弴弶弸弻弼弽弾弿彀彁彂彅彇彉彊彋彍彏彐彑彖彗彘彚彛彜彝彟彡彣彦彧彨彮彯彳彴彵彶彷彸彺彽彾徂徆徇徉徍徎徏従徔徕徖徚徛徜徝徟徢徣徤徥徦徨徫徬徭徯徰徱徲徳徴徶徸徺徻徼徾忀忁忂忄忇忈忉忊忋忎忏忐忑忒忓忔忕忖忚忛応忝忞忟忡忢忣忤忥忦忨忩忪忬忭忮忯忰忲忳忴忶忷忸忹忺忻忼忾怂怃怄怅怆怇怈怉怊怋怌怍怏怐怑怓怗怘怙怚怛怞怟怡怢怣怤怦怩怫怬怭怮怰怲怴怵怶怷怸怹怺怼怽怾怿恀恁恂恄恅恇恈恉恊恌恎恏恑恓恔恖恗恘恙恚恛恜恝恞恟恣恦恧恪恫恮恱恲恴恵恷恸恹恺恻恽恾恿悀悁悂悃悆悇悈悊悋悌悎悏悐悑悒悓悕悖悗悘悙悚悛悜悝悡悢悥悧悩悪悫悭悮悰悱悳悷悸悹悺悻悾悿惀惁惂惃惄惆惇惈惉惌惍惎惐惒惓惔惖惗惘惙惚惛惝惞惟惢惣惤惪惬惮惴惵惸惺惼惽惾惿愀愂愃愄愅愆愇愊愋愌愍愎愐愑愒愓愔愖愗愘愙愝愞愠愡愢愣愥愦愩愪愫愬愭愮愯愰愱愲愳愵愶愸愹愺愼慀慁慂慃慅慆慇慉慊慏慐慑慒慓慔慖慗慛慜慝慞慠慡慥慦慩慬慭慯慱慲慵慸慹慻慿憀憁憃憄憅憆憈憉憌憏憓憕憗憘憙憛憜憝憞憟憠憡憣憥憦憧憩憪憬憭憯憰憱憳憴憵憷憺憻憼憽憿懁懃懄懅懆懋懏懐懑懓懔懕懖懗懘懙懚懛懜懝懠懡懢懥懩懪懫懬懭懮懯懰懱懳懴懵懹懻懽懿戁戂戃戄戅戆戉戊戋戌戍戎戓戕戗戙戛戜戝戟戠戡戢戣戤戥戦戨戫戬戭戮戯戵戸戺戻戼戽戾扂扃扄扅扆扈扉扊扌扏扐払扖扗扙扚扜扝扟扠扡扢扤扥扦扨扪扱扲扴扵扷扸扺扻扽抁抂抃抅抆抇抈抉抋抌抍抎抏抐抔抙抜択抟抣抦抧抨抩抪抭抮抯抰抲抳抴抶抷抸抺抻抾抿拀拁拃拈拊拎拏拑拕拝拞拠拡拤拪拫拮拰拲拵拶拸拹拺拻拽挀挃挄挅挆挈挊挋挌挍挏挐挒挓挔挕挗挘挙挛挜挝挞挢挦挧挬挭挮挰挲挳挴挶挷挸挹挻挼挿捀捁捃捇捈捊捋捑捒捓捔捖捗捘捙捚捛捜捝捠捤捥捦捩捪捬捭捯捰捳捴捵捸捹捼捽捾捿掁掅掇掊掋掍掎掑掓掔掕掜掝掞掟掣掤掦掫掬掭掮掯掱掲掳掴掵掶掹掻掼掾掿揁揂揃揄揅揆揇揈揊揋揌揎揓揔揕揗揘揙揜揝揞揟揠揢揤揥揦揧揨揬揰揱揲揳揵揶揸揺揻揼揾揿搃搄搈搊搋搌搎搐搑搒搕搘搙搚搛搝搟搠搡搢搣搦搧搩搫搮搰搱搲搳搴搷搸搹搻搼搽搿摀摁摂摅摈摉摌摍摎摏摒摓摕摖摗摙摚摛摝摞摠摡摢摣摤摥摦摨摪摫摬摭摮摰摱摲摴摵摷摼摽摾摿撀撁撂撃撄撅撆撉撋撌撍撎撔撖撗撘撙撚撛撜撠撢撨撪撯撱撴撶撷撸撹撺撽擀擃擆擈擉擌擏擐擑擖擗擘擙擛擜擝擞擡擢擤擨擩擪擭擮擳擵擶擸擹擿攁攂攃攅攇攈攉攊攌攍攎攐攑攓攕攗攚攞攟攠攡攥攦攧攨攫攭攮攰攱攲攳攴攵攸攺攼攽敀敁敃敄敆敇敉敊敋敐敒敔敕敖敚敜敝敟敠敡敤敥敧敨敩敪敫敭敮敯敱敳敶敹敻敼敽敾敿斀斁斄斈斉斊斌斍斎斏斐斒斓斔斖斘斚斛斝斞斠斡斢斣斦斨斪斫斮斱斲斳斴斵斶斺斻斾斿旀旃旄旆旇旈旉旊旌旍旎旐旑旒旓旔旕旖旘旙旚旛旜旝旞旟旡旪旫旮旯旰旲旳旴旵旸旻旼旽旿昀昁昃昄昅昈昉昊昋昍昐昑昒昕昖昗昘昚昛昜昝昞昡昢昣昤昦昩昪昫昮昰昱昲昳昴昶昷昸昹昺昻昽昿晀晁晄晅晆晇晈晊晍晎晏晐晑晔晖晗晘晙晜晞晟晠晡晢晣晥晧晩晪晫晬晭晱晲晳晵晷晸晹晻晼晽晿暀暁暃暄暅暆暊暋暌暍暎暏暒暓暔暕暙暚暛暜暝暞暟暠暡暣暤暥暦暧暨暩暪暬暭暯暰暲暳暵暶暷暸暹暺暻暼暽暾暿曀曁曂曃曅曈曋曌曍曎曐曑曒曓曔曕曗曘曚曛曜曝曞曟曢曣曤曦曧曩曪曫曭曮曯曰曱曳曵曶曷曺曻曽朁朂朄朅朆朇朊朌朎朏朐朑朒朓朔朕朖朘朙朚朜朠朡朣朤朩札朰朲朳朷朸朹朻朼朾朿杁杄杅杇杊杋杌杍杒杓杔杕杗杘杙杚杛杝杞杢杣杤杦杧杩杪杫杬杮杲杳杵杶杷杸杹杺杻杼杽枀枂枃枅枆枇枈枊枋枌枍枎枏枑枒枓枔枖枘枙枛枞枟枠枡枤枥枦枧枨枩枬枭枮枰枲枳枵枸枹枺枻枼枽枾枿柀柁柂柃柅柆柇柈柉柊柋柌柍柎柕柖柗柘柙柚柛柝柞柟柡柢柣柤柦柧柨柩柪柫柭柮柯柰柲柶柷柸柹柼柽柾栀栂栃栄栆栉栊栌栍栎栐栒栔栕栘栙栚栛栜栝栟栠栣栤栥栦栧栨栩栫栬栭栮栯栱栲栳栴栵栶栺栻栾栿桀桁桄桇桉桊桋桍桎桏桓桔桕桖桗桘桙桚桛桜桝桞桟桠桡桢桤桧桪桫桬桭桯桰桲桳桴桵桷桸桹桻桼桽桾梀梂梃梄梇梈梉梊梋梌梍梎梏梐梑梒梓梕梙梚梛梞梠梡梣梤梥梩梪梫梬梮梱梴梵梶梷梸梹梺梻梼梽梾梿棁棂棃棅棆棇棈棌棎棏棐棑棓棔棙棛棜棝棞棢棣棤棥棦棨棩棪棫棬棭棯棰棳棴棷棸棹棻棼棽棾棿椀椁椂椃椄椆椇椈椉椊椋椌椐椑椓椔椕椖椘椙椚椛検椝椞椟椠椡椢椣椤椥椦椧椨椩椪椫椬椮椯椱椳椴椵椸椹椺椻椼椽楀楁楂楃楄楅楆楈楉楋楌楍楎楏楐楑楒楕楖楗楘楙楛楜楝楟楠楡楢楤楦楧楩楪楫楬楮楯楰楱楲楳楴楶楸楹楺楻楽楾楿榀榁榃榅榇榈榉榊榋榌榍榎榏榐榑榒榓榖榗榙榚榝榞榟榠榡榢榣榤榥榧榩榫榬榭榯榰榱榳榵榶榷榸榹榺榻榼榽榾槀槁槂槃槄槅槆槇槈槉槊槌槎槏槑槒槔槖槗様槙槚槛槜槝槞槟槠槡槢槣槥槦槩槪槬槭槯槰槱槲槴槵槷槸槹槺槻槾槿樀樃樄樆樇樈樉樋樌樍樎樏樐樒樔樕樖樗樘樚樛樜樝樥樦樨権樬樭樮樯樰樲樴樵樶樷樻樼樽樾橀橁橂橃橅橆橇橉橊橌橍橎橏橐橑橒橓橔橕橖橗橚橛橝橞橠橣橤橥橦橧橨橩橪橬橭橮橰橲橳橴橵橶橷橸橹橺橻橼橽橾橿檂檃檄檅檆檇檈檊檋檌檍檎檏檑檒檓檕檖檗檘檙檚檛檝檞檠檡檤檥檦檧檨檪檫檰檱檲檴檶檷檹檺檼檽檾檿櫀櫁櫂櫄櫆櫇櫉櫊櫋櫌櫎櫏櫐櫑櫒櫔櫕櫖櫗櫘櫙櫜櫡櫢櫣櫤櫦櫩櫭櫮櫯櫰櫲櫴櫵櫶櫷櫹櫺櫼櫽櫾櫿欀欁欂欃欆欈欉欋欌欎欔欕欗欙欚欛欜欟欤欥欦欨欩欪欫欬欭欮欯欰欱欳欴欶欷欸欹欻欼欿歀歁歂歃歄歅歆歈歊歋歍歏歑歒歓歔歕歖歗歘歙歚歜歝歞歠歨歩歫歬歭歮歯歰歱歳歵歶歺歽歾殁殂殄殅殆殇殈殌殍殎殏殐殑殒殓殔殕殗殙殚殛殜殝殟殠殡殣殥殦殧殩殪殬殱殳殶殸殹殽殾毂毃毄毇毈毉毋毌毎毐毑毓毖毗毘毚毜毝毞毟毠毢毣毤毥毦毨毩毪毭毮毰毱毲毳毴毵毶毷毸毹毺毻毼毽毾氀氁氃氄氅氆氇氉氋氍氎氐氒氕氖気氘氙氚氜氝氞氟氠氡氤氥氦氩氪氰氱氲氵氶氹氺氻氼氽氿汀汃汄汅汆汈汊汋汌汍汏汐汑汒汓汔汕汖汘汜汝汢汣汥汦汧汨汩汫汬汭汮汯汱汲汳汴汵汶汷汸汻汼汾汿沀沁沂沄沅沆沇沊沋沌沍沎沏沑沓沔沕沗沘沚沜沝沞沠沢沣沤沨沩沬沭沯沰沱沲沴沵沶沷沺泀泂泃泅泆泇泈泋泍泎泏泐泑泒泓泔泖泗泘泙泚泜泟泠泤泦泧泩泫泬泭泮泯泱泲泴泶泷泸泹泺泾泿洀洂洃洄洅洆洇洈洉洊洌洍洎洏洐洑洓洔洕洖洘洙洚洜洝洟洠洡洢洣洤洦洧洨洫洬洭洮洯洰洱洳洴洵洷洸洹洺洿浀浂浃浄浈浉浌浍浏浐浒浔浕浖浗浘浚浛浜浝浞浟浠浡浢浣浤浥浧浨浫浬浭浯浰浱浲浳浵浶浺浻浼浽浾涀涁涃涄涅涆涊涋涍涏涐涑涒涓涔涘涙涚涜涞涟涠涢涥涪涫涬涭涰涱涳涴涶涷涸涹涺涻涽涾涿淁淂淃淄淅淇淈淉淊淍淎淏淐淓淔淕淖淗淙淜淝淞淟淠淢淣淦淧淬淭淯淰淲淴淸淼淽淾淿渀渁渂渃渄渆渇済渉渋渌渍渎渏渑渒渓渕渘渚渜渝渞渟渥渧渨渪渫渭渮渰渱渲渳渵渶渷渹渻渼渽渿湀湁湂湄湅湆湇湈湉湌湍湎湏湐湑湒湓湔湕湗湙湚湛湜湝湟湠湡湢湣湤湥湦湨湩湪湫湬湭湮湰湱湲湳湴湵湶湷湸湹湺湻湽満溁溂溄溆溇溊溋溌溍溎溏溑溒溓溔溕溗溘溙溚溛溞溟溠溣溤溥溦溧溨溩溬溭溰溱溲溴溵溷溸溹溻溽溾溿滀滁滂滃滆滇滈滉滊滍滏滐滒滕滖滗滘滜滝滟滠滢滣滦滧滪滫滭滮滰滱滳滵滶滹滺滼滽漀漃漄漅漇漈漉漋漌漎漐漑漒漕漖漗漘漙漛漜漝漞漟漡漤漥漦漧漨漪漭漮漯漰漳漴漶漷漹漺漻漼漽潀潂潃潅潆潇潈潉潊潋潌潍潎潏潐潒潓潖潗潝潞潟潠潡潢潥潧潨潩潪潫潬潱潲潳潴潵潶潸潹潺潻潼潽潾澂澃澉澊澋澌澍澏澑澒澓澔澕澖澘澙澚澛澝澞澟澢澣澥澧澨澪澭澯澰澲澴澵澶澷澸澹澺澻澼澽澿濂濅濈濉濊濋濌濍濎濏濐濑濓濔濖濗濙濝濞濠濡濢濣濥濦濨濩濪濬濭濮濯濲濳濴濵濷濸濹濻濽瀀瀁瀄瀈瀊瀌瀍瀎瀐瀒瀓瀔瀖瀗瀙瀚瀛瀜瀞瀡瀢瀣瀤瀥瀩瀪瀫瀬瀭瀮瀯瀱瀳瀴瀵瀶瀷瀸瀹瀺瀻瀼瀽瀿灀灁灂灅灆灇灈灉灊灎灏灐灓灔灖灗灚灛灜灞灟灢灥灦灨灪灬灮灱灲灳灴灷灹灺灻炀炁炂炃炄炅炆炇炈炋炌炍炏炐炑炓炔炖炗炘炙炚炛炜炝炞炟炠炡炢炣炤炥炦炧炨炩炪炯炰炱炲炳炴炵炶炷炻炽炾炿烀烃烄烅烆烇烉烊烋烌烍烎烐烑烒烓烔烕烗烚烜烝烞烠烡烢烣烥烨烩烪烬烮烯烰烱烲烳烵烶烷烸烺烻烼烽烾烿焀焁焂焃焄焅焆焇焈焉焋焌焍焎焏焐焑焒焓焔焖焗焘焛焜焝焞焟焠焢焣焤焥焧焨焩焪焫焬焭焮焯焱焲焳焴焵焷焸焹焺焻焼焽焾焿煀煁煂煃煄煅煆煈煊煋煍煏煐煓煔煕煖煘煚煛煜煝煟煠煡煣煦煨煪煫煭煯煰煲煳煴煵煶煷煸煹煺煻煼煽煾煿熀熁熃熆熇熋熍熎熐熑熕熖熘熛熜熝熞熠熢熣熤熥熦熧熨熩熪熫熭熮熯熳熴熵熶熷熸熹熺熻熼熽熿燂燅燆燇燊燋燌燍燏燐燑燓燔燗燘燚燛燝燞燠燡燢燣燤燧燨燩燪燫燮燯燰燱燲燳燵燷燸燹燺燽燿爀爁爂爅爈爉爊爋爌爎爏爑爒爓爔爕爘爙爚爜爝爞爟爠爡爢爣爤爦爨爩爫爮爯爰爳爴爻爼爿牁牂牃牄牅牉牊牏牑牒牔牖牗牚牜牝牞牟牣牤牥牦牨牪牫牬牭牮牯牰牱牳牶牷牸牻牼牾牿犂犃犄犅犆犇犈犉犊犋犌犍犎犏犐犑犒犓犔犕犗犘犙犚犜犝犟犠犡犣犤犥犦犨犩犪犫犭犮犰犱犲犳犴犵犷犸犺犻犼犽犾犿狁狃狄狅狆狇狉狊狋狌狍狎狏狑狒狓狔狕狖狘狙狚狛狜狝狟狢狣狤狦狧狨狩狪狫狯狲狳狴狵狶狷狺狻狾狿猀猁猃猄猅猆猇猈猉猊猋猍猏猐猑猒猓猔猕猗猘猚猝猞猟猠猡猢猣猤猥猦猧猭猯猰猱猲猳猵猷猸猹猺猼猽獀獂獆獇獈獉獋獌獍獏獐獑獒獓獔獕獖獗獙獚獛獜獝獞獟獠獡獢獣獤獥獦獬獭獯獳獴獶獹獽獾獿玂玃玆玈玊玌玍玎玏玐玑玒玓玔玕玗玘玙玚玜玝玞玟玠玡玢玣玤玥玦玧玨玪玬玭玮玱玳玴玵玶玸玹玺玼玽玾玿珀珁珂珃珄珅珆珇珈珉珋珌珎珏珐珑珒珓珔珕珖珗珘珙珚珛珜珝珞珟珡珢珣珤珥珦珧珨珩珪珫珬珮珯珰珱珲珳珴珵珶珷珸珹珺珻珽珿琀琁琂琄琇琈琊琋琌琍琎琏琑琒琓琔琕琗琘琙琚琛琜琝琞琟琠琡琣琤琥琦琧琨琩琪琫琬琭琮琯琰琲琵琶琷琸琹琻琽琾瑀瑁瑂瑃瑄瑅瑆瑈瑉瑊瑌瑍瑎瑏瑐瑑瑓瑔瑕瑖瑗瑘瑙瑚瑛瑜瑝瑠瑡瑢瑥瑦瑧瑨瑫瑬瑭瑮瑱瑳瑴瑵瑶瑷瑸瑹瑺瑼瑾瑿璀璁璂璄璅璆璇璈璋璌璍璎璏璐璑璒璓璔璖璘璙璚璛璜璞璟璠璤璥璨璩璪璬璭璮璱璲璳璴璶璷璹璺璻瓀瓁瓂瓃瓆瓇瓈瓉瓋瓌瓍瓎瓐瓑瓒瓓瓖瓗瓘瓙瓝瓞瓟瓠瓡瓥瓧瓨瓩瓪瓫瓬瓭瓯瓰瓱瓲瓳瓴瓵瓸瓹瓺瓻瓼瓽瓾瓿甀甁甂甃甄甅甆甇甈甉甊甋甍"}

charclass_set = {k: set(v) for k, v in charclass_dict.items()}


@run_once('str')
def get_char_class(ch):
    for k, v in charclass_set.items():
        if ch in v:
            return k

    if re.match(r'\s', ch):
        return '空白'

    if re.match(r'\d', ch):
        return '数字'

    if re.match(r'[a-zA-Z]', ch):
        return '字母'

    if re.match(r'[\x00-\x7F]', ch):
        return '标点'

    return '其他字符'


def check_unclassified_chars(content, *, print_mode=0):
    """ 检查未被分类到的字符 """
    ct = Counter(content)
    ct2 = Counter()
    for ch, cnt in ct.most_common():
        cls = get_char_class(ch)
        if cls == '其他字符':
            if print_mode:
                print(ch, cnt)
            ct2[ch] = cnt
    return ct2


def get_charclass_num(content):
    """ 检查字符类型分布数量 """
    ct = Counter(content)
    ct2 = Counter()
    for ch, cnt in ct.most_common():
        cls = get_char_class(ch)
        ct2[cls] += cnt
    return ct2


def get_charclass_rate(content, round_digits=4):
    """ 检查字符类型分布数量

    :param str content: 文本内容
    """
    ct = get_charclass_num(content)

    # 这一类权重要翻倍
    for k in ['常用汉字', '繁体汉字', '偏僻汉字', '其他字符']:
        if k in ct:
            ct[k] *= 2

    total = sum(ct.values())
    ct2 = Counter()
    for k, v in ct.most_common():
        ct2[k] = v / total
        if round_digits is not None:
            ct2[k] = round(ct2[k], round_digits)
    return ct2


def check_language_from_counter(ct):
    """ 检查语言类型

    todo 这里的规则应该还可以再优化，以及不同的业务场景，这些规则应该也要再调整
        这个比例最早是给表格设计的，表格很可能表头是中文，中间都是英文、数字数据，此时仍然归为中文
        但如果是一般性的文档，可能要提高中文的比例，才能视为中文文档
    """
    ct['常用汉字'] = ct.get('常用汉字', 0)
    ct['偏僻汉字'] = ct.get('偏僻汉字', 0)

    if '繁体汉字' in ct:
        if safe_div(ct['繁体汉字'], ct['常用汉字']) > 0.1:
            return '繁体中文'

    if ct['常用汉字'] + ct['偏僻汉字']:
        return '中文'

    if '其他字符' in ct:
        if safe_div(ct['其他字符'], ct['字母']) > 0.1:
            return '其他'

    if '字母' in ct:
        return '英文'

    return '其他'


def check_language_from_content(content):
    ct = get_charclass_num(content)
    return check_language_from_counter(ct)
