import cdk = require('@aws-cdk/core');
import { IEcsApplication } from './application';
import { IEcsDeploymentConfig } from './deployment-config';
/**
 * Interface for an ECS deployment group.
 */
export interface IEcsDeploymentGroup extends cdk.IResource {
    /**
     * The reference to the CodeDeploy ECS Application that this Deployment Group belongs to.
     */
    readonly application: IEcsApplication;
    /**
     * The physical name of the CodeDeploy Deployment Group.
     * @attribute
     */
    readonly deploymentGroupName: string;
    /**
     * The ARN of this Deployment Group.
     * @attribute
     */
    readonly deploymentGroupArn: string;
    /**
     * The Deployment Configuration this Group uses.
     */
    readonly deploymentConfig: IEcsDeploymentConfig;
}
/**
 * Note: This class currently stands as a namespaced container for importing an ECS
 * Deployment Group defined outside the CDK app until CloudFormation supports provisioning
 * ECS Deployment Groups. Until then it is closed (private constructor) and does not
 * extend {@link cdk.Construct}.
 *
 * @resource AWS::CodeDeploy::DeploymentGroup
 */
export declare class EcsDeploymentGroup {
    /**
     * Import an ECS Deployment Group defined outside the CDK app.
     *
     * @param scope the parent Construct for this new Construct
     * @param id the logical ID of this new Construct
     * @param attrs the properties of the referenced Deployment Group
     * @returns a Construct representing a reference to an existing Deployment Group
     */
    static fromEcsDeploymentGroupAttributes(scope: cdk.Construct, id: string, attrs: EcsDeploymentGroupAttributes): IEcsDeploymentGroup;
    private constructor();
}
/**
 * Properties of a reference to a CodeDeploy ECS Deployment Group.
 *
 * @see EcsDeploymentGroup#fromEcsDeploymentGroupAttributes
 */
export interface EcsDeploymentGroupAttributes {
    /**
     * The reference to the CodeDeploy ECS Application
     * that this Deployment Group belongs to.
     */
    readonly application: IEcsApplication;
    /**
     * The physical, human-readable name of the CodeDeploy ECS Deployment Group
     * that we are referencing.
     */
    readonly deploymentGroupName: string;
    /**
     * The Deployment Configuration this Deployment Group uses.
     *
     * @default EcsDeploymentConfig.ALL_AT_ONCE
     */
    readonly deploymentConfig?: IEcsDeploymentConfig;
}
