"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const codedeploy = require("../../lib");
module.exports = {
    'CodeDeploy ECS Application': {
        'can be created'(test) {
            const stack = new cdk.Stack();
            new codedeploy.EcsApplication(stack, 'MyApp');
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::Application', {
                ComputePlatform: 'ECS',
            }));
            test.done();
        },
        'can be created with explicit name'(test) {
            const stack = new cdk.Stack();
            new codedeploy.EcsApplication(stack, 'MyApp', {
                applicationName: 'my-name',
            });
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::Application', {
                ApplicationName: 'my-name',
                ComputePlatform: 'ECS',
            }));
            test.done();
        },
    }
};
//# sourceMappingURL=data:application/json;base64,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