"use strict";
const cdk = require("@aws-cdk/core");
const codedeploy = require("../../lib");
const lib_1 = require("../../lib");
module.exports = {
    "CodeDeploy ECS DeploymentGroup": {
        'imported with fromEcsDeploymentGroupAttributes': {
            'defaults the Deployment Config to AllAtOnce'(test) {
                const stack = new cdk.Stack();
                const ecsApp = codedeploy.EcsApplication.fromEcsApplicationName(stack, 'EA', 'EcsApplication');
                const importedGroup = codedeploy.EcsDeploymentGroup.fromEcsDeploymentGroupAttributes(stack, 'EDG', {
                    application: ecsApp,
                    deploymentGroupName: 'EcsDeploymentGroup',
                });
                test.equal(importedGroup.deploymentConfig, lib_1.EcsDeploymentConfig.ALL_AT_ONCE);
                test.done();
            },
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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