"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const codedeploy = require("../../lib");
module.exports = {
    "CodeDeploy Lambda Application": {
        "can be created"(test) {
            const stack = new cdk.Stack();
            new codedeploy.LambdaApplication(stack, 'MyApp');
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::Application', {
                ComputePlatform: 'Lambda'
            }));
            test.done();
        },
        "can be created with explicit name"(test) {
            const stack = new cdk.Stack();
            new codedeploy.LambdaApplication(stack, 'MyApp', {
                applicationName: 'my-name',
            });
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::Application', {
                ApplicationName: 'my-name',
                ComputePlatform: 'Lambda'
            }));
            test.done();
        },
    }
};
//# sourceMappingURL=data:application/json;base64,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