"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const codedeploy = require("../../lib");
module.exports = {
    'CodeDeploy DeploymentConfig': {
        "can be created by specifying only minHealthyHostCount"(test) {
            const stack = new cdk.Stack();
            new codedeploy.ServerDeploymentConfig(stack, 'DeploymentConfig', {
                minimumHealthyHosts: codedeploy.MinimumHealthyHosts.count(1),
            });
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::DeploymentConfig', {
                "MinimumHealthyHosts": {
                    "Type": "HOST_COUNT",
                    "Value": 1,
                },
            }));
            test.done();
        },
        "can be created by specifying only minHealthyHostPercentage"(test) {
            const stack = new cdk.Stack();
            new codedeploy.ServerDeploymentConfig(stack, 'DeploymentConfig', {
                minimumHealthyHosts: codedeploy.MinimumHealthyHosts.percentage(75),
            });
            assert_1.expect(stack).to(assert_1.haveResource('AWS::CodeDeploy::DeploymentConfig', {
                "MinimumHealthyHosts": {
                    "Type": "FLEET_PERCENT",
                    "Value": 75,
                },
            }));
            test.done();
        },
        'can be imported'(test) {
            const stack = new cdk.Stack();
            const deploymentConfig = codedeploy.ServerDeploymentConfig.fromServerDeploymentConfigName(stack, 'MyDC', 'MyDC');
            test.notEqual(deploymentConfig, undefined);
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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