[![REUSE status](https://api.reuse.software/badge/github.com/SAP/generative-ai-toolkit-for-sap-hana-cloud)](https://api.reuse.software/info/github.com/SAP/generative-ai-toolkit-for-sap-hana-cloud)

# Generative AI Toolkit for SAP HANA Cloud

## About this project

Generative AI Client for SAP HANA Cloud is an extension of the existing HANA ML Python client library, mainly focusing on GenAI and related use cases. It includes many leading-edge GenAI related open source libraries and provides seamless integration with HANA ML, HANA vector engine, and other SAP GenAI Hub SDK, see our [Introduction](https://github.com/SAP/generative-ai-toolkit-for-sap-hana-cloud/blob/main/INTRODUCTION.md), [Notebook](https://github.com/SAP/generative-ai-toolkit-for-sap-hana-cloud/blob/main/nutest/testscripts/demo/e2e_scenarios/time_series_forecast_scenario_sales_refunds.ipynb) and [Documentation](https://sap.github.io/generative-ai-toolkit-for-sap-hana-cloud/).

## Requirements and Setup

The prerequisites for using the Generative AI Toolkit for SAP HANA Cloud are listed at [Prerequisites](https://sap.github.io/generative-ai-toolkit-for-sap-hana-cloud/hana_ai.html#prerequisites).

The Generative AI Toolkit for SAP HANA Cloud is available as a Python package. You can install it via `pip`:

```bash
pip install hana-ai
```

## Support, Feedback, Contributing

This project is open to feature requests/suggestions, bug reports etc. via [GitHub issues](https://github.com/SAP/generative-ai-toolkit-for-sap-hana-cloud/issues). Contribution and feedback are encouraged and always welcome. For more information about how to contribute, the project structure, as well as additional contribution information, see our [Contribution Guidelines](https://github.com/SAP/generative-ai-toolkit-for-sap-hana-cloud/blob/main/CONTRIBUTING.md).

## Security / Disclosure
If you find any bug that may be a security problem, please follow our instructions at [in our security policy](https://github.com/SAP/generative-ai-toolkit-for-sap-hana-cloud/security/policy) on how to report it. Please do not create GitHub issues for security-related doubts or problems.

## Code of Conduct

We as members, contributors, and leaders pledge to make participation in our community a harassment-free experience for everyone. By participating in this project, you agree to abide by its [Code of Conduct](https://github.com/SAP/.github/blob/main/CODE_OF_CONDUCT.md) at all times.

## Licensing

Copyright 2025 SAP SE or an SAP affiliate company and generative-ai-toolkit-for-sap-hana-cloud contributors. Please see our [LICENSE](https://github.com/SAP/generative-ai-toolkit-for-sap-hana-cloud/blob/main/LICENSE) for copyright and license information. Detailed information including third-party components and their licensing/copyright information is available [via the REUSE tool](https://api.reuse.software/info/github.com/SAP/generative-ai-toolkit-for-sap-hana-cloud).
